<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionDetailsPickup StructType
 * Meta information extracted from the WSDL
 * - documentation: Shipment position | Sendungsposition
 * @subpackage Structs
 */
class PositionDetailsPickup extends AbstractStructBase
{
    /**
     * The PackageAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount of packages | Packstückanzahl
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $PackageAmount;
    /**
     * The PackageType
     * Meta information extracted from the WSDL
     * - documentation: Type of package | Verpackungsart
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PackageType;
    /**
     * The GrossWeight
     * Meta information extracted from the WSDL
     * - documentation: Gross weight (in kg) | Bruttogewicht (in kg)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 1
     * - pattern: [1-9]{1}[0-9]{0,4}.[0-9]{2}
     * - totalDigits: 7
     * @var float
     */
    public $GrossWeight;
    /**
     * Constructor method for PositionDetailsPickup
     * @uses PositionDetailsPickup::setPackageAmount()
     * @uses PositionDetailsPickup::setPackageType()
     * @uses PositionDetailsPickup::setGrossWeight()
     * @param string $packageAmount
     * @param string $packageType
     * @param float $grossWeight
     */
    public function __construct($packageAmount = null, $packageType = null, $grossWeight = null)
    {
        $this
            ->setPackageAmount($packageAmount)
            ->setPackageType($packageType)
            ->setGrossWeight($grossWeight);
    }
    /**
     * Get PackageAmount value
     * @return string
     */
    public function getPackageAmount()
    {
        return $this->PackageAmount;
    }
    /**
     * Set PackageAmount value
     * @param string $packageAmount
     * @return \StructType\PositionDetailsPickup
     */
    public function setPackageAmount($packageAmount = null)
    {
        // validation for constraint: string
        if (!is_null($packageAmount) && !is_string($packageAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageAmount, true), gettype($packageAmount)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($packageAmount) && mb_strlen($packageAmount) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($packageAmount)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageAmount) && mb_strlen($packageAmount) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageAmount)), __LINE__);
        }
        $this->PackageAmount = $packageAmount;
        return $this;
    }
    /**
     * Get PackageType value
     * @return string
     */
    public function getPackageType()
    {
        return $this->PackageType;
    }
    /**
     * Set PackageType value
     * @uses \EnumType\CodelistPackagecodes::valueIsValid()
     * @uses \EnumType\CodelistPackagecodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packageType
     * @return \StructType\PositionDetailsPickup
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistPackagecodes::valueIsValid($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistPackagecodes', is_array($packageType) ? implode(', ', $packageType) : var_export($packageType, true), implode(', ', \EnumType\CodelistPackagecodes::getValidValues())), __LINE__);
        }
        $this->PackageType = $packageType;
        return $this;
    }
    /**
     * Get GrossWeight value
     * @return float
     */
    public function getGrossWeight()
    {
        return $this->GrossWeight;
    }
    /**
     * Set GrossWeight value
     * @param float $grossWeight
     * @return \StructType\PositionDetailsPickup
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeight) && !(is_float($grossWeight) || is_numeric($grossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($grossWeight) && mb_strlen(mb_substr($grossWeight, false !== mb_strpos($grossWeight, '.') ? mb_strpos($grossWeight, '.') + 1 : mb_strlen($grossWeight))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($grossWeight, true), mb_strlen(mb_substr($grossWeight, mb_strpos($grossWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.99)
        if (!is_null($grossWeight) && $grossWeight > 99999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.99', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($grossWeight) && $grossWeight < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,4}.[0-9]{2})
        if (!is_null($grossWeight) && !preg_match('/[1-9]{1}[0-9]{0,4}.[0-9]{2}/', $grossWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,4}.[0-9]{2}', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($grossWeight) && mb_strlen(preg_replace('/(\D)/', '', $grossWeight)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($grossWeight, true), mb_strlen(preg_replace('/(\D)/', '', $grossWeight))), __LINE__);
        }
        $this->GrossWeight = $grossWeight;
        return $this;
    }
}
