<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Loadinglist StructType
 * Meta information extracted from the WSDL
 * - documentation: FCM Loadinglist | FCM Ladeliste
 * @subpackage Structs
 */
class Loadinglist extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Language | Sprache
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Language;
    /**
     * The AX4LoadinglistNo
     * Meta information extracted from the WSDL
     * - documentation: AX4 Loadinglist no. | AX4 Ladelistennummer
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AX4LoadinglistNo;
    /**
     * The LoadinglistDocument
     * Meta information extracted from the WSDL
     * - documentation: Loadinglist document | Ladelistendokument
     * - base: xsd:base64Binary
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LoadinglistDocument;
    /**
     * The Errormessage
     * Meta information extracted from the WSDL
     * - documentation: Errormessage | Fehlerbeschreibung
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Errormessage;
    /**
     * Constructor method for Loadinglist
     * @uses Loadinglist::setLanguage()
     * @uses Loadinglist::setAX4LoadinglistNo()
     * @uses Loadinglist::setLoadinglistDocument()
     * @uses Loadinglist::setErrormessage()
     * @param string $language
     * @param string $aX4LoadinglistNo
     * @param string $loadinglistDocument
     * @param string $errormessage
     */
    public function __construct($language = null, $aX4LoadinglistNo = null, $loadinglistDocument = null, $errormessage = null)
    {
        $this
            ->setLanguage($language)
            ->setAX4LoadinglistNo($aX4LoadinglistNo)
            ->setLoadinglistDocument($loadinglistDocument)
            ->setErrormessage($errormessage);
    }
    /**
     * Get Language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @uses \EnumType\CodelistLanguages::valueIsValid()
     * @uses \EnumType\CodelistLanguages::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\Loadinglist
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistLanguages::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistLanguages', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\CodelistLanguages::getValidValues())), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get AX4LoadinglistNo value
     * @return string
     */
    public function getAX4LoadinglistNo()
    {
        return $this->AX4LoadinglistNo;
    }
    /**
     * Set AX4LoadinglistNo value
     * @param string $aX4LoadinglistNo
     * @return \StructType\Loadinglist
     */
    public function setAX4LoadinglistNo($aX4LoadinglistNo = null)
    {
        // validation for constraint: string
        if (!is_null($aX4LoadinglistNo) && !is_string($aX4LoadinglistNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aX4LoadinglistNo, true), gettype($aX4LoadinglistNo)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($aX4LoadinglistNo) && mb_strlen($aX4LoadinglistNo) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($aX4LoadinglistNo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aX4LoadinglistNo) && mb_strlen($aX4LoadinglistNo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aX4LoadinglistNo)), __LINE__);
        }
        $this->AX4LoadinglistNo = $aX4LoadinglistNo;
        return $this;
    }
    /**
     * Get LoadinglistDocument value
     * @return string
     */
    public function getLoadinglistDocument()
    {
        return $this->LoadinglistDocument;
    }
    /**
     * Set LoadinglistDocument value
     * @param string $loadinglistDocument
     * @return \StructType\Loadinglist
     */
    public function setLoadinglistDocument($loadinglistDocument = null)
    {
        // validation for constraint: string
        if (!is_null($loadinglistDocument) && !is_string($loadinglistDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadinglistDocument, true), gettype($loadinglistDocument)), __LINE__);
        }
        $this->LoadinglistDocument = $loadinglistDocument;
        return $this;
    }
    /**
     * Get Errormessage value
     * @return string
     */
    public function getErrormessage()
    {
        return $this->Errormessage;
    }
    /**
     * Set Errormessage value
     * @param string $errormessage
     * @return \StructType\Loadinglist
     */
    public function setErrormessage($errormessage = null)
    {
        // validation for constraint: string
        if (!is_null($errormessage) && !is_string($errormessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errormessage, true), gettype($errormessage)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($errormessage) && mb_strlen($errormessage) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($errormessage)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($errormessage) && mb_strlen($errormessage) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($errormessage)), __LINE__);
        }
        $this->Errormessage = $errormessage;
        return $this;
    }
}
