<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Barcode StructType
 * Meta information extracted from the WSDL
 * - documentation: Barcodes
 * @subpackage Structs
 */
class Barcode extends AbstractStructBase
{
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - documentation: Page size | Seitengröße
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PageSize;
    /**
     * The AX4ShipmentNo
     * Meta information extracted from the WSDL
     * - documentation: AX4 Shipment no. | AX4 Sendungsnummer
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AX4ShipmentNo;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Shipment[]
     */
    public $Shipment;
    /**
     * The Errormessage
     * Meta information extracted from the WSDL
     * - documentation: Errormessage | Fehlerbeschreibung
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Errormessage;
    /**
     * Constructor method for Barcode
     * @uses Barcode::setPageSize()
     * @uses Barcode::setAX4ShipmentNo()
     * @uses Barcode::setShipment()
     * @uses Barcode::setErrormessage()
     * @param string $pageSize
     * @param string $aX4ShipmentNo
     * @param \StructType\Shipment[] $shipment
     * @param string $errormessage
     */
    public function __construct($pageSize = null, $aX4ShipmentNo = null, array $shipment = array(), $errormessage = null)
    {
        $this
            ->setPageSize($pageSize)
            ->setAX4ShipmentNo($aX4ShipmentNo)
            ->setShipment($shipment)
            ->setErrormessage($errormessage);
    }
    /**
     * Get PageSize value
     * @return string
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @uses \EnumType\CodelistPagesize::valueIsValid()
     * @uses \EnumType\CodelistPagesize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pageSize
     * @return \StructType\Barcode
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistPagesize::valueIsValid($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistPagesize', is_array($pageSize) ? implode(', ', $pageSize) : var_export($pageSize, true), implode(', ', \EnumType\CodelistPagesize::getValidValues())), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get AX4ShipmentNo value
     * @return string
     */
    public function getAX4ShipmentNo()
    {
        return $this->AX4ShipmentNo;
    }
    /**
     * Set AX4ShipmentNo value
     * @param string $aX4ShipmentNo
     * @return \StructType\Barcode
     */
    public function setAX4ShipmentNo($aX4ShipmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($aX4ShipmentNo) && !is_string($aX4ShipmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aX4ShipmentNo, true), gettype($aX4ShipmentNo)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($aX4ShipmentNo) && mb_strlen($aX4ShipmentNo) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($aX4ShipmentNo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aX4ShipmentNo) && mb_strlen($aX4ShipmentNo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aX4ShipmentNo)), __LINE__);
        }
        $this->AX4ShipmentNo = $aX4ShipmentNo;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \StructType\Shipment[]
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * This method is responsible for validating the values passed to the setShipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentForArrayConstraintsFromSetShipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $barcodeShipmentItem) {
            // validation for constraint: itemType
            if (!$barcodeShipmentItem instanceof \StructType\Shipment) {
                $invalidValues[] = is_object($barcodeShipmentItem) ? get_class($barcodeShipmentItem) : sprintf('%s(%s)', gettype($barcodeShipmentItem), var_export($barcodeShipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Shipment property can only contain items of type \StructType\Shipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Shipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment[] $shipment
     * @return \StructType\Barcode
     */
    public function setShipment(array $shipment = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentArrayErrorMessage = self::validateShipmentForArrayConstraintsFromSetShipment($shipment))) {
            throw new \InvalidArgumentException($shipmentArrayErrorMessage, __LINE__);
        }
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Add item to Shipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment $item
     * @return \StructType\Barcode
     */
    public function addToShipment(\StructType\Shipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Shipment) {
            throw new \InvalidArgumentException(sprintf('The Shipment property can only contain items of type \StructType\Shipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Shipment[] = $item;
        return $this;
    }
    /**
     * Get Errormessage value
     * @return string
     */
    public function getErrormessage()
    {
        return $this->Errormessage;
    }
    /**
     * Set Errormessage value
     * @param string $errormessage
     * @return \StructType\Barcode
     */
    public function setErrormessage($errormessage = null)
    {
        // validation for constraint: string
        if (!is_null($errormessage) && !is_string($errormessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errormessage, true), gettype($errormessage)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($errormessage) && mb_strlen($errormessage) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($errormessage)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($errormessage) && mb_strlen($errormessage) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($errormessage)), __LINE__);
        }
        $this->Errormessage = $errormessage;
        return $this;
    }
}
