<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressConsignee StructType
 * Meta information extracted from the WSDL
 * - documentation: Consignee | Empfänger
 * @subpackage Structs
 */
class AddressConsignee extends AbstractStructBase
{
    /**
     * The Name1
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name1;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Street;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 2
     * - minOccurs: 1
     * @var string
     */
    public $Country;
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Zipcode;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $City;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The Name2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name2;
    /**
     * The Name3
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name3;
    /**
     * The Name4
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name4;
    /**
     * The Housenumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Housenumber;
    /**
     * The ILN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 13
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ILN;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The ContactPhone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPhone;
    /**
     * The ContactEmail
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactEmail;
    /**
     * Constructor method for AddressConsignee
     * @uses AddressConsignee::setName1()
     * @uses AddressConsignee::setStreet()
     * @uses AddressConsignee::setCountry()
     * @uses AddressConsignee::setZipcode()
     * @uses AddressConsignee::setCity()
     * @uses AddressConsignee::setCustomerNumber()
     * @uses AddressConsignee::setName2()
     * @uses AddressConsignee::setName3()
     * @uses AddressConsignee::setName4()
     * @uses AddressConsignee::setHousenumber()
     * @uses AddressConsignee::setILN()
     * @uses AddressConsignee::setContactName()
     * @uses AddressConsignee::setContactPhone()
     * @uses AddressConsignee::setContactEmail()
     * @param string $name1
     * @param string $street
     * @param string $country
     * @param string $zipcode
     * @param string $city
     * @param string $customerNumber
     * @param string $name2
     * @param string $name3
     * @param string $name4
     * @param string $housenumber
     * @param string $iLN
     * @param string $contactName
     * @param string $contactPhone
     * @param string $contactEmail
     */
    public function __construct($name1 = null, $street = null, $country = null, $zipcode = null, $city = null, $customerNumber = null, $name2 = null, $name3 = null, $name4 = null, $housenumber = null, $iLN = null, $contactName = null, $contactPhone = null, $contactEmail = null)
    {
        $this
            ->setName1($name1)
            ->setStreet($street)
            ->setCountry($country)
            ->setZipcode($zipcode)
            ->setCity($city)
            ->setCustomerNumber($customerNumber)
            ->setName2($name2)
            ->setName3($name3)
            ->setName4($name4)
            ->setHousenumber($housenumber)
            ->setILN($iLN)
            ->setContactName($contactName)
            ->setContactPhone($contactPhone)
            ->setContactEmail($contactEmail);
    }
    /**
     * Get Name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->Name1;
    }
    /**
     * Set Name1 value
     * @param string $name1
     * @return \StructType\AddressConsignee
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name1) && mb_strlen($name1) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name1) && mb_strlen($name1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name1)), __LINE__);
        }
        $this->Name1 = $name1;
        return $this;
    }
    /**
     * Get Street value
     * @return string
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\AddressConsignee
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($street) && mb_strlen($street) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($street) && mb_strlen($street) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get Country value
     * @return string
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\AddressConsignee
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($country) && mb_strlen($country) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($country)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($country) && mb_strlen($country) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Zipcode value
     * @return string
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \StructType\AddressConsignee
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($zipcode) && mb_strlen($zipcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($zipcode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($zipcode) && mb_strlen($zipcode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($zipcode)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get City value
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\AddressConsignee
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($city) && mb_strlen($city) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($city) && mb_strlen($city) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\AddressConsignee
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($customerNumber) && mb_strlen($customerNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($customerNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerNumber) && mb_strlen($customerNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get Name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->Name2;
    }
    /**
     * Set Name2 value
     * @param string $name2
     * @return \StructType\AddressConsignee
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name2) && mb_strlen($name2) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name2) && mb_strlen($name2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name2)), __LINE__);
        }
        $this->Name2 = $name2;
        return $this;
    }
    /**
     * Get Name3 value
     * @return string|null
     */
    public function getName3()
    {
        return $this->Name3;
    }
    /**
     * Set Name3 value
     * @param string $name3
     * @return \StructType\AddressConsignee
     */
    public function setName3($name3 = null)
    {
        // validation for constraint: string
        if (!is_null($name3) && !is_string($name3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name3, true), gettype($name3)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name3) && mb_strlen($name3) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name3)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name3) && mb_strlen($name3) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name3)), __LINE__);
        }
        $this->Name3 = $name3;
        return $this;
    }
    /**
     * Get Name4 value
     * @return string|null
     */
    public function getName4()
    {
        return $this->Name4;
    }
    /**
     * Set Name4 value
     * @param string $name4
     * @return \StructType\AddressConsignee
     */
    public function setName4($name4 = null)
    {
        // validation for constraint: string
        if (!is_null($name4) && !is_string($name4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name4, true), gettype($name4)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name4) && mb_strlen($name4) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name4)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name4) && mb_strlen($name4) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name4)), __LINE__);
        }
        $this->Name4 = $name4;
        return $this;
    }
    /**
     * Get Housenumber value
     * @return string|null
     */
    public function getHousenumber()
    {
        return $this->Housenumber;
    }
    /**
     * Set Housenumber value
     * @param string $housenumber
     * @return \StructType\AddressConsignee
     */
    public function setHousenumber($housenumber = null)
    {
        // validation for constraint: string
        if (!is_null($housenumber) && !is_string($housenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housenumber, true), gettype($housenumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($housenumber) && mb_strlen($housenumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($housenumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($housenumber) && mb_strlen($housenumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($housenumber)), __LINE__);
        }
        $this->Housenumber = $housenumber;
        return $this;
    }
    /**
     * Get ILN value
     * @return string|null
     */
    public function getILN()
    {
        return $this->ILN;
    }
    /**
     * Set ILN value
     * @param string $iLN
     * @return \StructType\AddressConsignee
     */
    public function setILN($iLN = null)
    {
        // validation for constraint: string
        if (!is_null($iLN) && !is_string($iLN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iLN, true), gettype($iLN)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($iLN) && mb_strlen($iLN) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($iLN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iLN) && mb_strlen($iLN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iLN)), __LINE__);
        }
        $this->ILN = $iLN;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\AddressConsignee
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($contactName) && mb_strlen($contactName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($contactName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contactName) && mb_strlen($contactName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get ContactPhone value
     * @return string|null
     */
    public function getContactPhone()
    {
        return $this->ContactPhone;
    }
    /**
     * Set ContactPhone value
     * @param string $contactPhone
     * @return \StructType\AddressConsignee
     */
    public function setContactPhone($contactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone) && !is_string($contactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPhone, true), gettype($contactPhone)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($contactPhone) && mb_strlen($contactPhone) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($contactPhone)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contactPhone) && mb_strlen($contactPhone) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contactPhone)), __LINE__);
        }
        $this->ContactPhone = $contactPhone;
        return $this;
    }
    /**
     * Get ContactEmail value
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->ContactEmail;
    }
    /**
     * Set ContactEmail value
     * @param string $contactEmail
     * @return \StructType\AddressConsignee
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmail, true), gettype($contactEmail)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($contactEmail) && mb_strlen($contactEmail) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($contactEmail)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contactEmail) && mb_strlen($contactEmail) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contactEmail)), __LINE__);
        }
        $this->ContactEmail = $contactEmail;
        return $this;
    }
}
