<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for codelistB2CDeliveryServices EnumType
 * @subpackage Enumerations
 */
class CodelistB2CDeliveryServices extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PND'
     * Meta information extracted from the WSDL
     * - documentation: B2C Fixtermin Zustelldatum (nur Deutschland) | B2C Fixed day (only Germany)
     * @return string 'PND'
     */
    const VALUE_PND = 'PND';
    /**
     * Constant for value 'P12'
     * Meta information extracted from the WSDL
     * - documentation: B2C Zustellung am Termintag 08:00 - 12:00 Uhr (vormittags)(nur Deutschland) | B2C Fixed day before noon 08:00 - 12:00 (only Germany)
     * @return string 'P12'
     */
    const VALUE_P_12 = 'P12';
    /**
     * Constant for value 'P16'
     * Meta information extracted from the WSDL
     * - documentation: B2C Zustellung am Termintag 12:00 - 16:00 Uhr (nachmittags)(nur Deutschland) | B2C Fixed day after noon 12:00 - 16:00 (only Germany)
     * @return string 'P16'
     */
    const VALUE_P_16 = 'P16';
    /**
     * Constant for value 'PAV'
     * Meta information extracted from the WSDL
     * - documentation: B2C Avis durch DHL Freight (nur Deutschland) | B2C Advice trough DHL Freight (only Germany)
     * @return string 'PAV'
     */
    const VALUE_PAV = 'PAV';
    /**
     * Return allowed values
     * @uses self::VALUE_PND
     * @uses self::VALUE_P_12
     * @uses self::VALUE_P_16
     * @uses self::VALUE_PAV
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PND,
            self::VALUE_P_12,
            self::VALUE_P_16,
            self::VALUE_PAV,
        );
    }
}
