<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Manifest StructType
 * Meta information extracted from the WSDL
 * - documentation: FCM Loadinglist | FCM Ladeliste
 * @subpackage Structs
 */
class Manifest extends AbstractStructBase
{
    /**
     * The AX4ManifestNo
     * Meta information extracted from the WSDL
     * - documentation: AX4 Manifest no. | AX4 Manifest
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AX4ManifestNo;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Shipment
     */
    public $Shipment;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - documentation: Remarks | Hinweis
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * Constructor method for Manifest
     * @uses Manifest::setAX4ManifestNo()
     * @uses Manifest::setShipment()
     * @uses Manifest::setRemarks()
     * @param string $aX4ManifestNo
     * @param \StructType\Shipment $shipment
     * @param string $remarks
     */
    public function __construct($aX4ManifestNo = null, \StructType\Shipment $shipment = null, $remarks = null)
    {
        $this
            ->setAX4ManifestNo($aX4ManifestNo)
            ->setShipment($shipment)
            ->setRemarks($remarks);
    }
    /**
     * Get AX4ManifestNo value
     * @return string
     */
    public function getAX4ManifestNo()
    {
        return $this->AX4ManifestNo;
    }
    /**
     * Set AX4ManifestNo value
     * @param string $aX4ManifestNo
     * @return \StructType\Manifest
     */
    public function setAX4ManifestNo($aX4ManifestNo = null)
    {
        // validation for constraint: string
        if (!is_null($aX4ManifestNo) && !is_string($aX4ManifestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aX4ManifestNo, true), gettype($aX4ManifestNo)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($aX4ManifestNo) && mb_strlen($aX4ManifestNo) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($aX4ManifestNo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aX4ManifestNo) && mb_strlen($aX4ManifestNo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aX4ManifestNo)), __LINE__);
        }
        $this->AX4ManifestNo = $aX4ManifestNo;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \StructType\Shipment
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \StructType\Shipment $shipment
     * @return \StructType\Manifest
     */
    public function setShipment(\StructType\Shipment $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\Manifest
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($remarks) && mb_strlen($remarks) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($remarks)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($remarks) && mb_strlen($remarks) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
}
