<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressOptionalConsignee StructType
 * Meta information extracted from the WSDL
 * - documentation: Optional consignee | abw. Empfänger
 * @subpackage Structs
 */
class AddressOptionalConsignee extends AbstractStructBase
{
    /**
     * The Name1
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name1;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Street;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 2
     * - minOccurs: 1
     * @var string
     */
    public $Country;
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Zipcode;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $City;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The Name2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name2;
    /**
     * The Name3
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name3;
    /**
     * The Name4
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name4;
    /**
     * Constructor method for AddressOptionalConsignee
     * @uses AddressOptionalConsignee::setName1()
     * @uses AddressOptionalConsignee::setStreet()
     * @uses AddressOptionalConsignee::setCountry()
     * @uses AddressOptionalConsignee::setZipcode()
     * @uses AddressOptionalConsignee::setCity()
     * @uses AddressOptionalConsignee::setCustomerNumber()
     * @uses AddressOptionalConsignee::setName2()
     * @uses AddressOptionalConsignee::setName3()
     * @uses AddressOptionalConsignee::setName4()
     * @param string $name1
     * @param string $street
     * @param string $country
     * @param string $zipcode
     * @param string $city
     * @param string $customerNumber
     * @param string $name2
     * @param string $name3
     * @param string $name4
     */
    public function __construct($name1 = null, $street = null, $country = null, $zipcode = null, $city = null, $customerNumber = null, $name2 = null, $name3 = null, $name4 = null)
    {
        $this
            ->setName1($name1)
            ->setStreet($street)
            ->setCountry($country)
            ->setZipcode($zipcode)
            ->setCity($city)
            ->setCustomerNumber($customerNumber)
            ->setName2($name2)
            ->setName3($name3)
            ->setName4($name4);
    }
    /**
     * Get Name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->Name1;
    }
    /**
     * Set Name1 value
     * @param string $name1
     * @return \StructType\AddressOptionalConsignee
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name1) && mb_strlen($name1) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name1) && mb_strlen($name1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name1)), __LINE__);
        }
        $this->Name1 = $name1;
        return $this;
    }
    /**
     * Get Street value
     * @return string
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\AddressOptionalConsignee
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($street) && mb_strlen($street) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($street) && mb_strlen($street) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get Country value
     * @return string
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\AddressOptionalConsignee
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($country) && mb_strlen($country) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($country)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($country) && mb_strlen($country) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Zipcode value
     * @return string
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \StructType\AddressOptionalConsignee
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($zipcode) && mb_strlen($zipcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($zipcode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($zipcode) && mb_strlen($zipcode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($zipcode)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get City value
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\AddressOptionalConsignee
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($city) && mb_strlen($city) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($city) && mb_strlen($city) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\AddressOptionalConsignee
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($customerNumber) && mb_strlen($customerNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($customerNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerNumber) && mb_strlen($customerNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get Name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->Name2;
    }
    /**
     * Set Name2 value
     * @param string $name2
     * @return \StructType\AddressOptionalConsignee
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name2) && mb_strlen($name2) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name2) && mb_strlen($name2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name2)), __LINE__);
        }
        $this->Name2 = $name2;
        return $this;
    }
    /**
     * Get Name3 value
     * @return string|null
     */
    public function getName3()
    {
        return $this->Name3;
    }
    /**
     * Set Name3 value
     * @param string $name3
     * @return \StructType\AddressOptionalConsignee
     */
    public function setName3($name3 = null)
    {
        // validation for constraint: string
        if (!is_null($name3) && !is_string($name3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name3, true), gettype($name3)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name3) && mb_strlen($name3) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name3)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name3) && mb_strlen($name3) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name3)), __LINE__);
        }
        $this->Name3 = $name3;
        return $this;
    }
    /**
     * Get Name4 value
     * @return string|null
     */
    public function getName4()
    {
        return $this->Name4;
    }
    /**
     * Set Name4 value
     * @param string $name4
     * @return \StructType\AddressOptionalConsignee
     */
    public function setName4($name4 = null)
    {
        // validation for constraint: string
        if (!is_null($name4) && !is_string($name4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name4, true), gettype($name4)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name4) && mb_strlen($name4) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name4)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name4) && mb_strlen($name4) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name4)), __LINE__);
        }
        $this->Name4 = $name4;
        return $this;
    }
}
