<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressConsignor StructType
 * Meta information extracted from the WSDL
 * - documentation: Consignor | Versender
 * @subpackage Structs
 */
class AddressConsignor extends AbstractStructBase
{
    /**
     * The AX4ID
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AX4ID;
    /**
     * Constructor method for AddressConsignor
     * @uses AddressConsignor::setAX4ID()
     * @param string $aX4ID
     */
    public function __construct($aX4ID = null)
    {
        $this
            ->setAX4ID($aX4ID);
    }
    /**
     * Get AX4ID value
     * @return string
     */
    public function getAX4ID()
    {
        return $this->AX4ID;
    }
    /**
     * Set AX4ID value
     * @param string $aX4ID
     * @return \StructType\AddressConsignor
     */
    public function setAX4ID($aX4ID = null)
    {
        // validation for constraint: string
        if (!is_null($aX4ID) && !is_string($aX4ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aX4ID, true), gettype($aX4ID)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($aX4ID) && mb_strlen($aX4ID) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($aX4ID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aX4ID) && mb_strlen($aX4ID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aX4ID)), __LINE__);
        }
        $this->AX4ID = $aX4ID;
        return $this;
    }
}
