<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The Consignee
     * Meta information extracted from the WSDL
     * - documentation: Consignee | Empfänger | Consignee/Customer | Empfänger/Kunde
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressConsignee
     */
    public $Consignee;
    /**
     * The InboundConsignee
     * Meta information extracted from the WSDL
     * - documentation: Consignee Inbound | Empfänger Inbound
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressInboundConsignee
     */
    public $InboundConsignee;
    /**
     * The OptionalConsignee
     * Meta information extracted from the WSDL
     * - documentation: Optional consignee | abw. Empfänger
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressOptionalConsignee
     */
    public $OptionalConsignee;
    /**
     * The NeutralConsignor
     * Meta information extracted from the WSDL
     * - documentation: Neutraler consignor | Neutraler Versender
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressNeutralConsignor
     */
    public $NeutralConsignor;
    /**
     * Constructor method for Address
     * @uses Address::setConsignee()
     * @uses Address::setInboundConsignee()
     * @uses Address::setOptionalConsignee()
     * @uses Address::setNeutralConsignor()
     * @param \StructType\AddressConsignee $consignee
     * @param \StructType\AddressInboundConsignee $inboundConsignee
     * @param \StructType\AddressOptionalConsignee $optionalConsignee
     * @param \StructType\AddressNeutralConsignor $neutralConsignor
     */
    public function __construct(\StructType\AddressConsignee $consignee = null, \StructType\AddressInboundConsignee $inboundConsignee = null, \StructType\AddressOptionalConsignee $optionalConsignee = null, \StructType\AddressNeutralConsignor $neutralConsignor = null)
    {
        $this
            ->setConsignee($consignee)
            ->setInboundConsignee($inboundConsignee)
            ->setOptionalConsignee($optionalConsignee)
            ->setNeutralConsignor($neutralConsignor);
    }
    /**
     * Get Consignee value
     * @return \StructType\AddressConsignee
     */
    public function getConsignee()
    {
        return $this->Consignee;
    }
    /**
     * Set Consignee value
     * @param \StructType\AddressConsignee $consignee
     * @return \StructType\Address
     */
    public function setConsignee(\StructType\AddressConsignee $consignee = null)
    {
        $this->Consignee = $consignee;
        return $this;
    }
    /**
     * Get InboundConsignee value
     * @return \StructType\AddressInboundConsignee|null
     */
    public function getInboundConsignee()
    {
        return $this->InboundConsignee;
    }
    /**
     * Set InboundConsignee value
     * @param \StructType\AddressInboundConsignee $inboundConsignee
     * @return \StructType\Address
     */
    public function setInboundConsignee(\StructType\AddressInboundConsignee $inboundConsignee = null)
    {
        $this->InboundConsignee = $inboundConsignee;
        return $this;
    }
    /**
     * Get OptionalConsignee value
     * @return \StructType\AddressOptionalConsignee|null
     */
    public function getOptionalConsignee()
    {
        return $this->OptionalConsignee;
    }
    /**
     * Set OptionalConsignee value
     * @param \StructType\AddressOptionalConsignee $optionalConsignee
     * @return \StructType\Address
     */
    public function setOptionalConsignee(\StructType\AddressOptionalConsignee $optionalConsignee = null)
    {
        $this->OptionalConsignee = $optionalConsignee;
        return $this;
    }
    /**
     * Get NeutralConsignor value
     * @return \StructType\AddressNeutralConsignor|null
     */
    public function getNeutralConsignor()
    {
        return $this->NeutralConsignor;
    }
    /**
     * Set NeutralConsignor value
     * @param \StructType\AddressNeutralConsignor $neutralConsignor
     * @return \StructType\Address
     */
    public function setNeutralConsignor(\StructType\AddressNeutralConsignor $neutralConsignor = null)
    {
        $this->NeutralConsignor = $neutralConsignor;
        return $this;
    }
}
