<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AX4ShipmentValidation StructType
 * Meta information extracted from the WSDL
 * - documentation: AX4 shipment validation | AX4 Sendungsvalidierung
 * @subpackage Structs
 */
class AX4ShipmentValidation extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Error[]
     */
    public $Error;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Shipment[]
     */
    public $Shipment;
    /**
     * Constructor method for AX4ShipmentValidation
     * @uses AX4ShipmentValidation::setError()
     * @uses AX4ShipmentValidation::setShipment()
     * @param \StructType\Error[] $error
     * @param \StructType\Shipment[] $shipment
     */
    public function __construct(array $error = array(), array $shipment = array())
    {
        $this
            ->setError($error)
            ->setShipment($shipment);
    }
    /**
     * Get Error value
     * @return \StructType\Error[]
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aX4ShipmentValidationErrorItem) {
            // validation for constraint: itemType
            if (!$aX4ShipmentValidationErrorItem instanceof \StructType\Error) {
                $invalidValues[] = is_object($aX4ShipmentValidationErrorItem) ? get_class($aX4ShipmentValidationErrorItem) : sprintf('%s(%s)', gettype($aX4ShipmentValidationErrorItem), var_export($aX4ShipmentValidationErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Error property can only contain items of type \StructType\Error, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error[] $error
     * @return \StructType\AX4ShipmentValidation
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error $item
     * @return \StructType\AX4ShipmentValidation
     */
    public function addToError(\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of type \StructType\Error, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \StructType\Shipment[]
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * This method is responsible for validating the values passed to the setShipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentForArrayConstraintsFromSetShipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aX4ShipmentValidationShipmentItem) {
            // validation for constraint: itemType
            if (!$aX4ShipmentValidationShipmentItem instanceof \StructType\Shipment) {
                $invalidValues[] = is_object($aX4ShipmentValidationShipmentItem) ? get_class($aX4ShipmentValidationShipmentItem) : sprintf('%s(%s)', gettype($aX4ShipmentValidationShipmentItem), var_export($aX4ShipmentValidationShipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Shipment property can only contain items of type \StructType\Shipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Shipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment[] $shipment
     * @return \StructType\AX4ShipmentValidation
     */
    public function setShipment(array $shipment = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentArrayErrorMessage = self::validateShipmentForArrayConstraintsFromSetShipment($shipment))) {
            throw new \InvalidArgumentException($shipmentArrayErrorMessage, __LINE__);
        }
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Add item to Shipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment $item
     * @return \StructType\AX4ShipmentValidation
     */
    public function addToShipment(\StructType\Shipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Shipment) {
            throw new \InvalidArgumentException(sprintf('The Shipment property can only contain items of type \StructType\Shipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Shipment[] = $item;
        return $this;
    }
}
