<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Deletion ServiceType
 * @subpackage Services
 */
class Deletion extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ShipmentDeletion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShipmentDeletionRequest $shipmentDeletionRequest
     * @return \StructType\ShipmentDeletionResponse|bool
     */
    public function ShipmentDeletion(\StructType\ShipmentDeletionRequest $shipmentDeletionRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ShipmentDeletion($shipmentDeletionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShipmentDeletionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
