<?php

namespace Novadan\Sanalsantral\\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sendsms ServiceType
 * @subpackage Services
 */
class Sendsms extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named send_sms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $username
     * @param string $password
     * @param string $text
     * @param string $recievers
     * @param string $baslik
     * @return string|bool
     */
    public function send_sms($username, $password, $text, $recievers, $baslik)
    {
        try {
            $this->setResult($this->getSoapClient()->send_sms($username, $password, $text, $recievers, $baslik));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
