<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiparisKayit_C2C StructType
 * @subpackage Structs
 */
class SiparisKayit_C2C extends AbstractStructBase
{
    /**
     * The pOdemeSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pOdemeSekli;
    /**
     * The pTeslimSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pTeslimSekli;
    /**
     * The pKargoCinsi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pKargoCinsi;
    /**
     * The pGonSms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pGonSms;
    /**
     * The pAliciSms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pAliciSms;
    /**
     * The pKapidaTahsilat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pKapidaTahsilat;
    /**
     * The pKullaniciAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pKullaniciAdi;
    /**
     * The pSifre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pSifre;
    /**
     * The pSiparisNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pSiparisNo;
    /**
     * The pBarkodText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pBarkodText;
    /**
     * The pIrsaliyeNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pIrsaliyeNo;
    /**
     * The pUrunBedeli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUrunBedeli;
    /**
     * The pGonderiParcaList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGonderiParca
     */
    public $pGonderiParcaList;
    /**
     * The pGonderenMusteri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Gonderici
     */
    public $pGonderenMusteri;
    /**
     * The pAliciMusteri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Alici
     */
    public $pAliciMusteri;
    /**
     * The pAciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pAciklama;
    /**
     * Constructor method for SiparisKayit_C2C
     * @uses SiparisKayit_C2C::setPOdemeSekli()
     * @uses SiparisKayit_C2C::setPTeslimSekli()
     * @uses SiparisKayit_C2C::setPKargoCinsi()
     * @uses SiparisKayit_C2C::setPGonSms()
     * @uses SiparisKayit_C2C::setPAliciSms()
     * @uses SiparisKayit_C2C::setPKapidaTahsilat()
     * @uses SiparisKayit_C2C::setPKullaniciAdi()
     * @uses SiparisKayit_C2C::setPSifre()
     * @uses SiparisKayit_C2C::setPSiparisNo()
     * @uses SiparisKayit_C2C::setPBarkodText()
     * @uses SiparisKayit_C2C::setPIrsaliyeNo()
     * @uses SiparisKayit_C2C::setPUrunBedeli()
     * @uses SiparisKayit_C2C::setPGonderiParcaList()
     * @uses SiparisKayit_C2C::setPGonderenMusteri()
     * @uses SiparisKayit_C2C::setPAliciMusteri()
     * @uses SiparisKayit_C2C::setPAciklama()
     * @param string $pOdemeSekli
     * @param string $pTeslimSekli
     * @param string $pKargoCinsi
     * @param string $pGonSms
     * @param string $pAliciSms
     * @param string $pKapidaTahsilat
     * @param string $pKullaniciAdi
     * @param string $pSifre
     * @param string $pSiparisNo
     * @param string $pBarkodText
     * @param string $pIrsaliyeNo
     * @param string $pUrunBedeli
     * @param \ArrayType\ArrayOfGonderiParca $pGonderiParcaList
     * @param \StructType\Gonderici $pGonderenMusteri
     * @param \StructType\Alici $pAliciMusteri
     * @param string $pAciklama
     */
    public function __construct($pOdemeSekli = null, $pTeslimSekli = null, $pKargoCinsi = null, $pGonSms = null, $pAliciSms = null, $pKapidaTahsilat = null, $pKullaniciAdi = null, $pSifre = null, $pSiparisNo = null, $pBarkodText = null, $pIrsaliyeNo = null, $pUrunBedeli = null, \ArrayType\ArrayOfGonderiParca $pGonderiParcaList = null, \StructType\Gonderici $pGonderenMusteri = null, \StructType\Alici $pAliciMusteri = null, $pAciklama = null)
    {
        $this
            ->setPOdemeSekli($pOdemeSekli)
            ->setPTeslimSekli($pTeslimSekli)
            ->setPKargoCinsi($pKargoCinsi)
            ->setPGonSms($pGonSms)
            ->setPAliciSms($pAliciSms)
            ->setPKapidaTahsilat($pKapidaTahsilat)
            ->setPKullaniciAdi($pKullaniciAdi)
            ->setPSifre($pSifre)
            ->setPSiparisNo($pSiparisNo)
            ->setPBarkodText($pBarkodText)
            ->setPIrsaliyeNo($pIrsaliyeNo)
            ->setPUrunBedeli($pUrunBedeli)
            ->setPGonderiParcaList($pGonderiParcaList)
            ->setPGonderenMusteri($pGonderenMusteri)
            ->setPAliciMusteri($pAliciMusteri)
            ->setPAciklama($pAciklama);
    }
    /**
     * Get pOdemeSekli value
     * @return string
     */
    public function getPOdemeSekli()
    {
        return $this->pOdemeSekli;
    }
    /**
     * Set pOdemeSekli value
     * @uses \EnumType\OdemeSekli::valueIsValid()
     * @uses \EnumType\OdemeSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pOdemeSekli
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPOdemeSekli($pOdemeSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OdemeSekli::valueIsValid($pOdemeSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OdemeSekli', is_array($pOdemeSekli) ? implode(', ', $pOdemeSekli) : var_export($pOdemeSekli, true), implode(', ', \EnumType\OdemeSekli::getValidValues())), __LINE__);
        }
        $this->pOdemeSekli = $pOdemeSekli;
        return $this;
    }
    /**
     * Get pTeslimSekli value
     * @return string
     */
    public function getPTeslimSekli()
    {
        return $this->pTeslimSekli;
    }
    /**
     * Set pTeslimSekli value
     * @uses \EnumType\TeslimSekli::valueIsValid()
     * @uses \EnumType\TeslimSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pTeslimSekli
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPTeslimSekli($pTeslimSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TeslimSekli::valueIsValid($pTeslimSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TeslimSekli', is_array($pTeslimSekli) ? implode(', ', $pTeslimSekli) : var_export($pTeslimSekli, true), implode(', ', \EnumType\TeslimSekli::getValidValues())), __LINE__);
        }
        $this->pTeslimSekli = $pTeslimSekli;
        return $this;
    }
    /**
     * Get pKargoCinsi value
     * @return string
     */
    public function getPKargoCinsi()
    {
        return $this->pKargoCinsi;
    }
    /**
     * Set pKargoCinsi value
     * @uses \EnumType\KargoCinsi::valueIsValid()
     * @uses \EnumType\KargoCinsi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pKargoCinsi
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPKargoCinsi($pKargoCinsi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KargoCinsi::valueIsValid($pKargoCinsi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KargoCinsi', is_array($pKargoCinsi) ? implode(', ', $pKargoCinsi) : var_export($pKargoCinsi, true), implode(', ', \EnumType\KargoCinsi::getValidValues())), __LINE__);
        }
        $this->pKargoCinsi = $pKargoCinsi;
        return $this;
    }
    /**
     * Get pGonSms value
     * @return string
     */
    public function getPGonSms()
    {
        return $this->pGonSms;
    }
    /**
     * Set pGonSms value
     * @uses \EnumType\GondericiSms::valueIsValid()
     * @uses \EnumType\GondericiSms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pGonSms
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPGonSms($pGonSms = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GondericiSms::valueIsValid($pGonSms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GondericiSms', is_array($pGonSms) ? implode(', ', $pGonSms) : var_export($pGonSms, true), implode(', ', \EnumType\GondericiSms::getValidValues())), __LINE__);
        }
        $this->pGonSms = $pGonSms;
        return $this;
    }
    /**
     * Get pAliciSms value
     * @return string
     */
    public function getPAliciSms()
    {
        return $this->pAliciSms;
    }
    /**
     * Set pAliciSms value
     * @uses \EnumType\AliciSms::valueIsValid()
     * @uses \EnumType\AliciSms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pAliciSms
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPAliciSms($pAliciSms = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AliciSms::valueIsValid($pAliciSms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AliciSms', is_array($pAliciSms) ? implode(', ', $pAliciSms) : var_export($pAliciSms, true), implode(', ', \EnumType\AliciSms::getValidValues())), __LINE__);
        }
        $this->pAliciSms = $pAliciSms;
        return $this;
    }
    /**
     * Get pKapidaTahsilat value
     * @return string
     */
    public function getPKapidaTahsilat()
    {
        return $this->pKapidaTahsilat;
    }
    /**
     * Set pKapidaTahsilat value
     * @uses \EnumType\KapidaOdeme::valueIsValid()
     * @uses \EnumType\KapidaOdeme::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pKapidaTahsilat
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPKapidaTahsilat($pKapidaTahsilat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KapidaOdeme::valueIsValid($pKapidaTahsilat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KapidaOdeme', is_array($pKapidaTahsilat) ? implode(', ', $pKapidaTahsilat) : var_export($pKapidaTahsilat, true), implode(', ', \EnumType\KapidaOdeme::getValidValues())), __LINE__);
        }
        $this->pKapidaTahsilat = $pKapidaTahsilat;
        return $this;
    }
    /**
     * Get pKullaniciAdi value
     * @return string|null
     */
    public function getPKullaniciAdi()
    {
        return $this->pKullaniciAdi;
    }
    /**
     * Set pKullaniciAdi value
     * @param string $pKullaniciAdi
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPKullaniciAdi($pKullaniciAdi = null)
    {
        // validation for constraint: string
        if (!is_null($pKullaniciAdi) && !is_string($pKullaniciAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pKullaniciAdi, true), gettype($pKullaniciAdi)), __LINE__);
        }
        $this->pKullaniciAdi = $pKullaniciAdi;
        return $this;
    }
    /**
     * Get pSifre value
     * @return string|null
     */
    public function getPSifre()
    {
        return $this->pSifre;
    }
    /**
     * Set pSifre value
     * @param string $pSifre
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPSifre($pSifre = null)
    {
        // validation for constraint: string
        if (!is_null($pSifre) && !is_string($pSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSifre, true), gettype($pSifre)), __LINE__);
        }
        $this->pSifre = $pSifre;
        return $this;
    }
    /**
     * Get pSiparisNo value
     * @return string|null
     */
    public function getPSiparisNo()
    {
        return $this->pSiparisNo;
    }
    /**
     * Set pSiparisNo value
     * @param string $pSiparisNo
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPSiparisNo($pSiparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($pSiparisNo) && !is_string($pSiparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSiparisNo, true), gettype($pSiparisNo)), __LINE__);
        }
        $this->pSiparisNo = $pSiparisNo;
        return $this;
    }
    /**
     * Get pBarkodText value
     * @return string|null
     */
    public function getPBarkodText()
    {
        return $this->pBarkodText;
    }
    /**
     * Set pBarkodText value
     * @param string $pBarkodText
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPBarkodText($pBarkodText = null)
    {
        // validation for constraint: string
        if (!is_null($pBarkodText) && !is_string($pBarkodText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pBarkodText, true), gettype($pBarkodText)), __LINE__);
        }
        $this->pBarkodText = $pBarkodText;
        return $this;
    }
    /**
     * Get pIrsaliyeNo value
     * @return string|null
     */
    public function getPIrsaliyeNo()
    {
        return $this->pIrsaliyeNo;
    }
    /**
     * Set pIrsaliyeNo value
     * @param string $pIrsaliyeNo
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPIrsaliyeNo($pIrsaliyeNo = null)
    {
        // validation for constraint: string
        if (!is_null($pIrsaliyeNo) && !is_string($pIrsaliyeNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIrsaliyeNo, true), gettype($pIrsaliyeNo)), __LINE__);
        }
        $this->pIrsaliyeNo = $pIrsaliyeNo;
        return $this;
    }
    /**
     * Get pUrunBedeli value
     * @return string|null
     */
    public function getPUrunBedeli()
    {
        return $this->pUrunBedeli;
    }
    /**
     * Set pUrunBedeli value
     * @param string $pUrunBedeli
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPUrunBedeli($pUrunBedeli = null)
    {
        // validation for constraint: string
        if (!is_null($pUrunBedeli) && !is_string($pUrunBedeli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pUrunBedeli, true), gettype($pUrunBedeli)), __LINE__);
        }
        $this->pUrunBedeli = $pUrunBedeli;
        return $this;
    }
    /**
     * Get pGonderiParcaList value
     * @return \ArrayType\ArrayOfGonderiParca|null
     */
    public function getPGonderiParcaList()
    {
        return $this->pGonderiParcaList;
    }
    /**
     * Set pGonderiParcaList value
     * @param \ArrayType\ArrayOfGonderiParca $pGonderiParcaList
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPGonderiParcaList(\ArrayType\ArrayOfGonderiParca $pGonderiParcaList = null)
    {
        $this->pGonderiParcaList = $pGonderiParcaList;
        return $this;
    }
    /**
     * Get pGonderenMusteri value
     * @return \StructType\Gonderici|null
     */
    public function getPGonderenMusteri()
    {
        return $this->pGonderenMusteri;
    }
    /**
     * Set pGonderenMusteri value
     * @param \StructType\Gonderici $pGonderenMusteri
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPGonderenMusteri(\StructType\Gonderici $pGonderenMusteri = null)
    {
        $this->pGonderenMusteri = $pGonderenMusteri;
        return $this;
    }
    /**
     * Get pAliciMusteri value
     * @return \StructType\Alici|null
     */
    public function getPAliciMusteri()
    {
        return $this->pAliciMusteri;
    }
    /**
     * Set pAliciMusteri value
     * @param \StructType\Alici $pAliciMusteri
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPAliciMusteri(\StructType\Alici $pAliciMusteri = null)
    {
        $this->pAliciMusteri = $pAliciMusteri;
        return $this;
    }
    /**
     * Get pAciklama value
     * @return string|null
     */
    public function getPAciklama()
    {
        return $this->pAciklama;
    }
    /**
     * Set pAciklama value
     * @param string $pAciklama
     * @return \StructType\SiparisKayit_C2C
     */
    public function setPAciklama($pAciklama = null)
    {
        // validation for constraint: string
        if (!is_null($pAciklama) && !is_string($pAciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAciklama, true), gettype($pAciklama)), __LINE__);
        }
        $this->pAciklama = $pAciklama;
        return $this;
    }
}
