<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GelecekIadeSiparisKayit StructType
 * @subpackage Structs
 */
class GelecekIadeSiparisKayit extends AbstractStructBase
{
    /**
     * The pOdemeSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pOdemeSekli;
    /**
     * The pKullaniciAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pKullaniciAdi;
    /**
     * The pSifre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pSifre;
    /**
     * The pSiparisNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pSiparisNo;
    /**
     * The pIrsaliyeNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pIrsaliyeNo;
    /**
     * The pGonderenMusteri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Gonderici
     */
    public $pGonderenMusteri;
    /**
     * The pAciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pAciklama;
    /**
     * Constructor method for GelecekIadeSiparisKayit
     * @uses GelecekIadeSiparisKayit::setPOdemeSekli()
     * @uses GelecekIadeSiparisKayit::setPKullaniciAdi()
     * @uses GelecekIadeSiparisKayit::setPSifre()
     * @uses GelecekIadeSiparisKayit::setPSiparisNo()
     * @uses GelecekIadeSiparisKayit::setPIrsaliyeNo()
     * @uses GelecekIadeSiparisKayit::setPGonderenMusteri()
     * @uses GelecekIadeSiparisKayit::setPAciklama()
     * @param string $pOdemeSekli
     * @param string $pKullaniciAdi
     * @param string $pSifre
     * @param string $pSiparisNo
     * @param string $pIrsaliyeNo
     * @param \StructType\Gonderici $pGonderenMusteri
     * @param string $pAciklama
     */
    public function __construct($pOdemeSekli = null, $pKullaniciAdi = null, $pSifre = null, $pSiparisNo = null, $pIrsaliyeNo = null, \StructType\Gonderici $pGonderenMusteri = null, $pAciklama = null)
    {
        $this
            ->setPOdemeSekli($pOdemeSekli)
            ->setPKullaniciAdi($pKullaniciAdi)
            ->setPSifre($pSifre)
            ->setPSiparisNo($pSiparisNo)
            ->setPIrsaliyeNo($pIrsaliyeNo)
            ->setPGonderenMusteri($pGonderenMusteri)
            ->setPAciklama($pAciklama);
    }
    /**
     * Get pOdemeSekli value
     * @return string
     */
    public function getPOdemeSekli()
    {
        return $this->pOdemeSekli;
    }
    /**
     * Set pOdemeSekli value
     * @uses \EnumType\OdemeSekli::valueIsValid()
     * @uses \EnumType\OdemeSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pOdemeSekli
     * @return \StructType\GelecekIadeSiparisKayit
     */
    public function setPOdemeSekli($pOdemeSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OdemeSekli::valueIsValid($pOdemeSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OdemeSekli', is_array($pOdemeSekli) ? implode(', ', $pOdemeSekli) : var_export($pOdemeSekli, true), implode(', ', \EnumType\OdemeSekli::getValidValues())), __LINE__);
        }
        $this->pOdemeSekli = $pOdemeSekli;
        return $this;
    }
    /**
     * Get pKullaniciAdi value
     * @return string|null
     */
    public function getPKullaniciAdi()
    {
        return $this->pKullaniciAdi;
    }
    /**
     * Set pKullaniciAdi value
     * @param string $pKullaniciAdi
     * @return \StructType\GelecekIadeSiparisKayit
     */
    public function setPKullaniciAdi($pKullaniciAdi = null)
    {
        // validation for constraint: string
        if (!is_null($pKullaniciAdi) && !is_string($pKullaniciAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pKullaniciAdi, true), gettype($pKullaniciAdi)), __LINE__);
        }
        $this->pKullaniciAdi = $pKullaniciAdi;
        return $this;
    }
    /**
     * Get pSifre value
     * @return string|null
     */
    public function getPSifre()
    {
        return $this->pSifre;
    }
    /**
     * Set pSifre value
     * @param string $pSifre
     * @return \StructType\GelecekIadeSiparisKayit
     */
    public function setPSifre($pSifre = null)
    {
        // validation for constraint: string
        if (!is_null($pSifre) && !is_string($pSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSifre, true), gettype($pSifre)), __LINE__);
        }
        $this->pSifre = $pSifre;
        return $this;
    }
    /**
     * Get pSiparisNo value
     * @return string|null
     */
    public function getPSiparisNo()
    {
        return $this->pSiparisNo;
    }
    /**
     * Set pSiparisNo value
     * @param string $pSiparisNo
     * @return \StructType\GelecekIadeSiparisKayit
     */
    public function setPSiparisNo($pSiparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($pSiparisNo) && !is_string($pSiparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSiparisNo, true), gettype($pSiparisNo)), __LINE__);
        }
        $this->pSiparisNo = $pSiparisNo;
        return $this;
    }
    /**
     * Get pIrsaliyeNo value
     * @return string|null
     */
    public function getPIrsaliyeNo()
    {
        return $this->pIrsaliyeNo;
    }
    /**
     * Set pIrsaliyeNo value
     * @param string $pIrsaliyeNo
     * @return \StructType\GelecekIadeSiparisKayit
     */
    public function setPIrsaliyeNo($pIrsaliyeNo = null)
    {
        // validation for constraint: string
        if (!is_null($pIrsaliyeNo) && !is_string($pIrsaliyeNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIrsaliyeNo, true), gettype($pIrsaliyeNo)), __LINE__);
        }
        $this->pIrsaliyeNo = $pIrsaliyeNo;
        return $this;
    }
    /**
     * Get pGonderenMusteri value
     * @return \StructType\Gonderici|null
     */
    public function getPGonderenMusteri()
    {
        return $this->pGonderenMusteri;
    }
    /**
     * Set pGonderenMusteri value
     * @param \StructType\Gonderici $pGonderenMusteri
     * @return \StructType\GelecekIadeSiparisKayit
     */
    public function setPGonderenMusteri(\StructType\Gonderici $pGonderenMusteri = null)
    {
        $this->pGonderenMusteri = $pGonderenMusteri;
        return $this;
    }
    /**
     * Get pAciklama value
     * @return string|null
     */
    public function getPAciklama()
    {
        return $this->pAciklama;
    }
    /**
     * Set pAciklama value
     * @param string $pAciklama
     * @return \StructType\GelecekIadeSiparisKayit
     */
    public function setPAciklama($pAciklama = null)
    {
        // validation for constraint: string
        if (!is_null($pAciklama) && !is_string($pAciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAciklama, true), gettype($pAciklama)), __LINE__);
        }
        $this->pAciklama = $pAciklama;
        return $this;
    }
}
