<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdrestenAlimSiparisKayit StructType
 * @subpackage Structs
 */
class AdrestenAlimSiparisKayit extends AbstractStructBase
{
    /**
     * The pAlimsekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pAlimsekli;
    /**
     * The pOdemeSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pOdemeSekli;
    /**
     * The pKullaniciAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pKullaniciAdi;
    /**
     * The pSifre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pSifre;
    /**
     * The pSiparisNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pSiparisNo;
    /**
     * The pIrsaliyeNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pIrsaliyeNo;
    /**
     * The pAlimIstekTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pAlimIstekTarihi;
    /**
     * The pGonderenMusteri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Gonderici
     */
    public $pGonderenMusteri;
    /**
     * The pAliciMusteri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Alici
     */
    public $pAliciMusteri;
    /**
     * The pAciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pAciklama;
    /**
     * Constructor method for AdrestenAlimSiparisKayit
     * @uses AdrestenAlimSiparisKayit::setPAlimsekli()
     * @uses AdrestenAlimSiparisKayit::setPOdemeSekli()
     * @uses AdrestenAlimSiparisKayit::setPKullaniciAdi()
     * @uses AdrestenAlimSiparisKayit::setPSifre()
     * @uses AdrestenAlimSiparisKayit::setPSiparisNo()
     * @uses AdrestenAlimSiparisKayit::setPIrsaliyeNo()
     * @uses AdrestenAlimSiparisKayit::setPAlimIstekTarihi()
     * @uses AdrestenAlimSiparisKayit::setPGonderenMusteri()
     * @uses AdrestenAlimSiparisKayit::setPAliciMusteri()
     * @uses AdrestenAlimSiparisKayit::setPAciklama()
     * @param string $pAlimsekli
     * @param string $pOdemeSekli
     * @param string $pKullaniciAdi
     * @param string $pSifre
     * @param string $pSiparisNo
     * @param string $pIrsaliyeNo
     * @param string $pAlimIstekTarihi
     * @param \StructType\Gonderici $pGonderenMusteri
     * @param \StructType\Alici $pAliciMusteri
     * @param string $pAciklama
     */
    public function __construct($pAlimsekli = null, $pOdemeSekli = null, $pKullaniciAdi = null, $pSifre = null, $pSiparisNo = null, $pIrsaliyeNo = null, $pAlimIstekTarihi = null, \StructType\Gonderici $pGonderenMusteri = null, \StructType\Alici $pAliciMusteri = null, $pAciklama = null)
    {
        $this
            ->setPAlimsekli($pAlimsekli)
            ->setPOdemeSekli($pOdemeSekli)
            ->setPKullaniciAdi($pKullaniciAdi)
            ->setPSifre($pSifre)
            ->setPSiparisNo($pSiparisNo)
            ->setPIrsaliyeNo($pIrsaliyeNo)
            ->setPAlimIstekTarihi($pAlimIstekTarihi)
            ->setPGonderenMusteri($pGonderenMusteri)
            ->setPAliciMusteri($pAliciMusteri)
            ->setPAciklama($pAciklama);
    }
    /**
     * Get pAlimsekli value
     * @return string
     */
    public function getPAlimsekli()
    {
        return $this->pAlimsekli;
    }
    /**
     * Set pAlimsekli value
     * @uses \EnumType\AlimSekli::valueIsValid()
     * @uses \EnumType\AlimSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pAlimsekli
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPAlimsekli($pAlimsekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AlimSekli::valueIsValid($pAlimsekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AlimSekli', is_array($pAlimsekli) ? implode(', ', $pAlimsekli) : var_export($pAlimsekli, true), implode(', ', \EnumType\AlimSekli::getValidValues())), __LINE__);
        }
        $this->pAlimsekli = $pAlimsekli;
        return $this;
    }
    /**
     * Get pOdemeSekli value
     * @return string
     */
    public function getPOdemeSekli()
    {
        return $this->pOdemeSekli;
    }
    /**
     * Set pOdemeSekli value
     * @uses \EnumType\OdemeSekli::valueIsValid()
     * @uses \EnumType\OdemeSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pOdemeSekli
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPOdemeSekli($pOdemeSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OdemeSekli::valueIsValid($pOdemeSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OdemeSekli', is_array($pOdemeSekli) ? implode(', ', $pOdemeSekli) : var_export($pOdemeSekli, true), implode(', ', \EnumType\OdemeSekli::getValidValues())), __LINE__);
        }
        $this->pOdemeSekli = $pOdemeSekli;
        return $this;
    }
    /**
     * Get pKullaniciAdi value
     * @return string|null
     */
    public function getPKullaniciAdi()
    {
        return $this->pKullaniciAdi;
    }
    /**
     * Set pKullaniciAdi value
     * @param string $pKullaniciAdi
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPKullaniciAdi($pKullaniciAdi = null)
    {
        // validation for constraint: string
        if (!is_null($pKullaniciAdi) && !is_string($pKullaniciAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pKullaniciAdi, true), gettype($pKullaniciAdi)), __LINE__);
        }
        $this->pKullaniciAdi = $pKullaniciAdi;
        return $this;
    }
    /**
     * Get pSifre value
     * @return string|null
     */
    public function getPSifre()
    {
        return $this->pSifre;
    }
    /**
     * Set pSifre value
     * @param string $pSifre
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPSifre($pSifre = null)
    {
        // validation for constraint: string
        if (!is_null($pSifre) && !is_string($pSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSifre, true), gettype($pSifre)), __LINE__);
        }
        $this->pSifre = $pSifre;
        return $this;
    }
    /**
     * Get pSiparisNo value
     * @return string|null
     */
    public function getPSiparisNo()
    {
        return $this->pSiparisNo;
    }
    /**
     * Set pSiparisNo value
     * @param string $pSiparisNo
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPSiparisNo($pSiparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($pSiparisNo) && !is_string($pSiparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSiparisNo, true), gettype($pSiparisNo)), __LINE__);
        }
        $this->pSiparisNo = $pSiparisNo;
        return $this;
    }
    /**
     * Get pIrsaliyeNo value
     * @return string|null
     */
    public function getPIrsaliyeNo()
    {
        return $this->pIrsaliyeNo;
    }
    /**
     * Set pIrsaliyeNo value
     * @param string $pIrsaliyeNo
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPIrsaliyeNo($pIrsaliyeNo = null)
    {
        // validation for constraint: string
        if (!is_null($pIrsaliyeNo) && !is_string($pIrsaliyeNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIrsaliyeNo, true), gettype($pIrsaliyeNo)), __LINE__);
        }
        $this->pIrsaliyeNo = $pIrsaliyeNo;
        return $this;
    }
    /**
     * Get pAlimIstekTarihi value
     * @return string|null
     */
    public function getPAlimIstekTarihi()
    {
        return $this->pAlimIstekTarihi;
    }
    /**
     * Set pAlimIstekTarihi value
     * @param string $pAlimIstekTarihi
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPAlimIstekTarihi($pAlimIstekTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($pAlimIstekTarihi) && !is_string($pAlimIstekTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAlimIstekTarihi, true), gettype($pAlimIstekTarihi)), __LINE__);
        }
        $this->pAlimIstekTarihi = $pAlimIstekTarihi;
        return $this;
    }
    /**
     * Get pGonderenMusteri value
     * @return \StructType\Gonderici|null
     */
    public function getPGonderenMusteri()
    {
        return $this->pGonderenMusteri;
    }
    /**
     * Set pGonderenMusteri value
     * @param \StructType\Gonderici $pGonderenMusteri
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPGonderenMusteri(\StructType\Gonderici $pGonderenMusteri = null)
    {
        $this->pGonderenMusteri = $pGonderenMusteri;
        return $this;
    }
    /**
     * Get pAliciMusteri value
     * @return \StructType\Alici|null
     */
    public function getPAliciMusteri()
    {
        return $this->pAliciMusteri;
    }
    /**
     * Set pAliciMusteri value
     * @param \StructType\Alici $pAliciMusteri
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPAliciMusteri(\StructType\Alici $pAliciMusteri = null)
    {
        $this->pAliciMusteri = $pAliciMusteri;
        return $this;
    }
    /**
     * Get pAciklama value
     * @return string|null
     */
    public function getPAciklama()
    {
        return $this->pAciklama;
    }
    /**
     * Set pAciklama value
     * @param string $pAciklama
     * @return \StructType\AdrestenAlimSiparisKayit
     */
    public function setPAciklama($pAciklama = null)
    {
        // validation for constraint: string
        if (!is_null($pAciklama) && !is_string($pAciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAciklama, true), gettype($pAciklama)), __LINE__);
        }
        $this->pAciklama = $pAciklama;
        return $this;
    }
}
