<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Siparis ServiceType
 * @subpackage Services
 */
class Siparis extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SiparisKayit_C2C
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisKayit_C2C $parameters
     * @return \StructType\SiparisKayit_C2CResponse|bool
     */
    public function SiparisKayit_C2C(\StructType\SiparisKayit_C2C $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisKayit_C2C($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisKayit_B2B
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisKayit_B2B $parameters
     * @return \StructType\SiparisKayit_B2BResponse|bool
     */
    public function SiparisKayit_B2B(\StructType\SiparisKayit_B2B $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisKayit_B2B($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisIptali_C2C
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisIptali_C2C $parameters
     * @return \StructType\SiparisIptali_C2CResponse|bool
     */
    public function SiparisIptali_C2C(\StructType\SiparisIptali_C2C $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisIptali_C2C($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SiparisIptali_C2CResponse|\StructType\SiparisKayit_B2BResponse|\StructType\SiparisKayit_C2CResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
