<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://service.mngkargo.com.tr/musterikargosiparis/musterisiparisnew.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://service.mngkargo.com.tr/musterikargosiparis/musterisiparisnew.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Siparis ServiceType
 */
$siparis = new \ServiceType\Siparis($options);
/**
 * Sample call for SiparisKayit_C2C operation/method
 */
if ($siparis->SiparisKayit_C2C(new \StructType\SiparisKayit_C2C()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for SiparisKayit_B2B operation/method
 */
if ($siparis->SiparisKayit_B2B(new \StructType\SiparisKayit_B2B()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for SiparisIptali_C2C operation/method
 */
if ($siparis->SiparisIptali_C2C(new \StructType\SiparisIptali_C2C()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Samples for Gelecek ServiceType
 */
$gelecek = new \ServiceType\Gelecek($options);
/**
 * Sample call for GelecekIadeSiparisKayit operation/method
 */
if ($gelecek->GelecekIadeSiparisKayit(new \StructType\GelecekIadeSiparisKayit()) !== false) {
    print_r($gelecek->getResult());
} else {
    print_r($gelecek->getLastError());
}
/**
 * Sample call for GelecekGonderiKayit operation/method
 */
if ($gelecek->GelecekGonderiKayit(new \StructType\GelecekGonderiKayit()) !== false) {
    print_r($gelecek->getResult());
} else {
    print_r($gelecek->getLastError());
}
/**
 * Sample call for GelecekIadeSiparisIptali operation/method
 */
if ($gelecek->GelecekIadeSiparisIptali(new \StructType\GelecekIadeSiparisIptali()) !== false) {
    print_r($gelecek->getResult());
} else {
    print_r($gelecek->getLastError());
}
/**
 * Sample call for GelecekIadeSiparisKontrol operation/method
 */
if ($gelecek->GelecekIadeSiparisKontrol(new \StructType\GelecekIadeSiparisKontrol()) !== false) {
    print_r($gelecek->getResult());
} else {
    print_r($gelecek->getLastError());
}
/**
 * Samples for Adresten ServiceType
 */
$adresten = new \ServiceType\Adresten($options);
/**
 * Sample call for AdrestenAlimSiparisKayit operation/method
 */
if ($adresten->AdrestenAlimSiparisKayit(new \StructType\AdrestenAlimSiparisKayit()) !== false) {
    print_r($adresten->getResult());
} else {
    print_r($adresten->getLastError());
}
