<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GonderiParca StructType
 * @subpackage Structs
 */
class GonderiParca extends AbstractStructBase
{
    /**
     * The Kg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Kg;
    /**
     * The Desi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Desi;
    /**
     * The Adet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Adet;
    /**
     * The Icerik
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Icerik;
    /**
     * Constructor method for GonderiParca
     * @uses GonderiParca::setKg()
     * @uses GonderiParca::setDesi()
     * @uses GonderiParca::setAdet()
     * @uses GonderiParca::setIcerik()
     * @param int $kg
     * @param int $desi
     * @param int $adet
     * @param string $icerik
     */
    public function __construct($kg = null, $desi = null, $adet = null, $icerik = null)
    {
        $this
            ->setKg($kg)
            ->setDesi($desi)
            ->setAdet($adet)
            ->setIcerik($icerik);
    }
    /**
     * Get Kg value
     * @return int
     */
    public function getKg()
    {
        return $this->Kg;
    }
    /**
     * Set Kg value
     * @param int $kg
     * @return \StructType\GonderiParca
     */
    public function setKg($kg = null)
    {
        // validation for constraint: int
        if (!is_null($kg) && !(is_int($kg) || ctype_digit($kg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kg, true), gettype($kg)), __LINE__);
        }
        $this->Kg = $kg;
        return $this;
    }
    /**
     * Get Desi value
     * @return int
     */
    public function getDesi()
    {
        return $this->Desi;
    }
    /**
     * Set Desi value
     * @param int $desi
     * @return \StructType\GonderiParca
     */
    public function setDesi($desi = null)
    {
        // validation for constraint: int
        if (!is_null($desi) && !(is_int($desi) || ctype_digit($desi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($desi, true), gettype($desi)), __LINE__);
        }
        $this->Desi = $desi;
        return $this;
    }
    /**
     * Get Adet value
     * @return int
     */
    public function getAdet()
    {
        return $this->Adet;
    }
    /**
     * Set Adet value
     * @param int $adet
     * @return \StructType\GonderiParca
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: int
        if (!is_null($adet) && !(is_int($adet) || ctype_digit($adet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adet, true), gettype($adet)), __LINE__);
        }
        $this->Adet = $adet;
        return $this;
    }
    /**
     * Get Icerik value
     * @return string|null
     */
    public function getIcerik()
    {
        return $this->Icerik;
    }
    /**
     * Set Icerik value
     * @param string $icerik
     * @return \StructType\GonderiParca
     */
    public function setIcerik($icerik = null)
    {
        // validation for constraint: string
        if (!is_null($icerik) && !is_string($icerik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($icerik, true), gettype($icerik)), __LINE__);
        }
        $this->Icerik = $icerik;
        return $this;
    }
}
