<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Celsius ServiceType
 * @subpackage Services
 */
class Celsius extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CelsiusToFahrenheit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CelsiusToFahrenheit $parameters
     * @return \StructType\CelsiusToFahrenheitResponse|bool
     */
    public function CelsiusToFahrenheit(\StructType\CelsiusToFahrenheit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CelsiusToFahrenheit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CelsiusToFahrenheitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
