<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomsDeclarationType StructType
 * Meta information extracted from the WSDL
 * - maxOccurs: 1
 * - minOccurs: 0
 * - type: xsd:string
 * @subpackage Structs
 */
class CustomsDeclarationType extends AbstractStructBase
{
    /**
     * The content
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $content;
    /**
     * The currencyCode
     * Meta information extracted from the WSDL
     * - documentation: Code (ISO 4217) of the currency in which the values of the items specified in the shipmentContentsDetails element are expressed. example: EUR
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currencyCode;
    /**
     * The shipmentContentsDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ShipmentContentsDetailsType[]
     */
    public $shipmentContentsDetails;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: CN type.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The accompanyingDocuments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccompanyingDocumentsType[]
     */
    public $accompanyingDocuments;
    /**
     * The explanation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $explanation;
    /**
     * The postalCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postalCharges;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The importerReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $importerReferenceNumber;
    /**
     * The importerPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $importerPhoneNumber;
    /**
     * The customsReferenceNumber
     * @var string
     */
    public $customsReferenceNumber;
    /**
     * Constructor method for CustomsDeclarationType
     * @uses CustomsDeclarationType::setContent()
     * @uses CustomsDeclarationType::setCurrencyCode()
     * @uses CustomsDeclarationType::setShipmentContentsDetails()
     * @uses CustomsDeclarationType::setType()
     * @uses CustomsDeclarationType::setAccompanyingDocuments()
     * @uses CustomsDeclarationType::setExplanation()
     * @uses CustomsDeclarationType::setPostalCharges()
     * @uses CustomsDeclarationType::setComments()
     * @uses CustomsDeclarationType::setImporterReferenceNumber()
     * @uses CustomsDeclarationType::setImporterPhoneNumber()
     * @uses CustomsDeclarationType::setCustomsReferenceNumber()
     * @param string $content
     * @param string $currencyCode
     * @param \StructType\ShipmentContentsDetailsType[] $shipmentContentsDetails
     * @param string $type
     * @param \StructType\AccompanyingDocumentsType[] $accompanyingDocuments
     * @param string $explanation
     * @param string $postalCharges
     * @param string $comments
     * @param string $importerReferenceNumber
     * @param string $importerPhoneNumber
     * @param string $customsReferenceNumber
     */
    public function __construct($content = null, $currencyCode = null, array $shipmentContentsDetails = array(), $type = null, array $accompanyingDocuments = array(), $explanation = null, $postalCharges = null, $comments = null, $importerReferenceNumber = null, $importerPhoneNumber = null, $customsReferenceNumber = null)
    {
        $this
            ->setContent($content)
            ->setCurrencyCode($currencyCode)
            ->setShipmentContentsDetails($shipmentContentsDetails)
            ->setType($type)
            ->setAccompanyingDocuments($accompanyingDocuments)
            ->setExplanation($explanation)
            ->setPostalCharges($postalCharges)
            ->setComments($comments)
            ->setImporterReferenceNumber($importerReferenceNumber)
            ->setImporterPhoneNumber($importerPhoneNumber)
            ->setCustomsReferenceNumber($customsReferenceNumber);
    }
    /**
     * Get content value
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @uses \EnumType\CustomsDeclarationContentEnum::valueIsValid()
     * @uses \EnumType\CustomsDeclarationContentEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $content
     * @return \StructType\CustomsDeclarationType
     */
    public function setContent($content = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomsDeclarationContentEnum::valueIsValid($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomsDeclarationContentEnum', is_array($content) ? implode(', ', $content) : var_export($content, true), implode(', ', \EnumType\CustomsDeclarationContentEnum::getValidValues())), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \StructType\CustomsDeclarationType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get shipmentContentsDetails value
     * @return \StructType\ShipmentContentsDetailsType[]
     */
    public function getShipmentContentsDetails()
    {
        return $this->shipmentContentsDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentContentsDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentContentsDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentContentsDetailsForArrayConstraintsFromSetShipmentContentsDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customsDeclarationTypeShipmentContentsDetailsItem) {
            // validation for constraint: itemType
            if (!$customsDeclarationTypeShipmentContentsDetailsItem instanceof \StructType\ShipmentContentsDetailsType) {
                $invalidValues[] = is_object($customsDeclarationTypeShipmentContentsDetailsItem) ? get_class($customsDeclarationTypeShipmentContentsDetailsItem) : sprintf('%s(%s)', gettype($customsDeclarationTypeShipmentContentsDetailsItem), var_export($customsDeclarationTypeShipmentContentsDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentContentsDetails property can only contain items of type \StructType\ShipmentContentsDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentContentsDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentContentsDetailsType[] $shipmentContentsDetails
     * @return \StructType\CustomsDeclarationType
     */
    public function setShipmentContentsDetails(array $shipmentContentsDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentContentsDetailsArrayErrorMessage = self::validateShipmentContentsDetailsForArrayConstraintsFromSetShipmentContentsDetails($shipmentContentsDetails))) {
            throw new \InvalidArgumentException($shipmentContentsDetailsArrayErrorMessage, __LINE__);
        }
        $this->shipmentContentsDetails = $shipmentContentsDetails;
        return $this;
    }
    /**
     * Add item to shipmentContentsDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentContentsDetailsType $item
     * @return \StructType\CustomsDeclarationType
     */
    public function addToShipmentContentsDetails(\StructType\ShipmentContentsDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentContentsDetailsType) {
            throw new \InvalidArgumentException(sprintf('The shipmentContentsDetails property can only contain items of type \StructType\ShipmentContentsDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipmentContentsDetails[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\CustomsDeclarationTypeEnum::valueIsValid()
     * @uses \EnumType\CustomsDeclarationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\CustomsDeclarationType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomsDeclarationTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomsDeclarationTypeEnum', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\CustomsDeclarationTypeEnum::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get accompanyingDocuments value
     * @return \StructType\AccompanyingDocumentsType[]|null
     */
    public function getAccompanyingDocuments()
    {
        return $this->accompanyingDocuments;
    }
    /**
     * This method is responsible for validating the values passed to the setAccompanyingDocuments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccompanyingDocuments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccompanyingDocumentsForArrayConstraintsFromSetAccompanyingDocuments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customsDeclarationTypeAccompanyingDocumentsItem) {
            // validation for constraint: itemType
            if (!$customsDeclarationTypeAccompanyingDocumentsItem instanceof \StructType\AccompanyingDocumentsType) {
                $invalidValues[] = is_object($customsDeclarationTypeAccompanyingDocumentsItem) ? get_class($customsDeclarationTypeAccompanyingDocumentsItem) : sprintf('%s(%s)', gettype($customsDeclarationTypeAccompanyingDocumentsItem), var_export($customsDeclarationTypeAccompanyingDocumentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The accompanyingDocuments property can only contain items of type \StructType\AccompanyingDocumentsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set accompanyingDocuments value
     * @throws \InvalidArgumentException
     * @param \StructType\AccompanyingDocumentsType[] $accompanyingDocuments
     * @return \StructType\CustomsDeclarationType
     */
    public function setAccompanyingDocuments(array $accompanyingDocuments = array())
    {
        // validation for constraint: array
        if ('' !== ($accompanyingDocumentsArrayErrorMessage = self::validateAccompanyingDocumentsForArrayConstraintsFromSetAccompanyingDocuments($accompanyingDocuments))) {
            throw new \InvalidArgumentException($accompanyingDocumentsArrayErrorMessage, __LINE__);
        }
        $this->accompanyingDocuments = $accompanyingDocuments;
        return $this;
    }
    /**
     * Add item to accompanyingDocuments value
     * @throws \InvalidArgumentException
     * @param \StructType\AccompanyingDocumentsType $item
     * @return \StructType\CustomsDeclarationType
     */
    public function addToAccompanyingDocuments(\StructType\AccompanyingDocumentsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccompanyingDocumentsType) {
            throw new \InvalidArgumentException(sprintf('The accompanyingDocuments property can only contain items of type \StructType\AccompanyingDocumentsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->accompanyingDocuments[] = $item;
        return $this;
    }
    /**
     * Get explanation value
     * @return string|null
     */
    public function getExplanation()
    {
        return $this->explanation;
    }
    /**
     * Set explanation value
     * @param string $explanation
     * @return \StructType\CustomsDeclarationType
     */
    public function setExplanation($explanation = null)
    {
        // validation for constraint: string
        if (!is_null($explanation) && !is_string($explanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($explanation, true), gettype($explanation)), __LINE__);
        }
        $this->explanation = $explanation;
        return $this;
    }
    /**
     * Get postalCharges value
     * @return string|null
     */
    public function getPostalCharges()
    {
        return $this->postalCharges;
    }
    /**
     * Set postalCharges value
     * @param string $postalCharges
     * @return \StructType\CustomsDeclarationType
     */
    public function setPostalCharges($postalCharges = null)
    {
        // validation for constraint: string
        if (!is_null($postalCharges) && !is_string($postalCharges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCharges, true), gettype($postalCharges)), __LINE__);
        }
        $this->postalCharges = $postalCharges;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\CustomsDeclarationType
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get importerReferenceNumber value
     * @return string|null
     */
    public function getImporterReferenceNumber()
    {
        return $this->importerReferenceNumber;
    }
    /**
     * Set importerReferenceNumber value
     * @param string $importerReferenceNumber
     * @return \StructType\CustomsDeclarationType
     */
    public function setImporterReferenceNumber($importerReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($importerReferenceNumber) && !is_string($importerReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importerReferenceNumber, true), gettype($importerReferenceNumber)), __LINE__);
        }
        $this->importerReferenceNumber = $importerReferenceNumber;
        return $this;
    }
    /**
     * Get importerPhoneNumber value
     * @return string|null
     */
    public function getImporterPhoneNumber()
    {
        return $this->importerPhoneNumber;
    }
    /**
     * Set importerPhoneNumber value
     * @param string $importerPhoneNumber
     * @return \StructType\CustomsDeclarationType
     */
    public function setImporterPhoneNumber($importerPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($importerPhoneNumber) && !is_string($importerPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importerPhoneNumber, true), gettype($importerPhoneNumber)), __LINE__);
        }
        $this->importerPhoneNumber = $importerPhoneNumber;
        return $this;
    }
    /**
     * Get customsReferenceNumber value
     * @return string|null
     */
    public function getCustomsReferenceNumber()
    {
        return $this->customsReferenceNumber;
    }
    /**
     * Set customsReferenceNumber value
     * @param string $customsReferenceNumber
     * @return \StructType\CustomsDeclarationType
     */
    public function setCustomsReferenceNumber($customsReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customsReferenceNumber) && !is_string($customsReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsReferenceNumber, true), gettype($customsReferenceNumber)), __LINE__);
        }
        $this->customsReferenceNumber = $customsReferenceNumber;
        return $this;
    }
}
