<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getUrzedyNadania
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUrzedyNadania $parameters
     * @return \StructType\GetUrzedyNadaniaResponse|bool
     */
    public function getUrzedyNadania(\StructType\GetUrzedyNadania $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUrzedyNadania($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUrzedyWydajaceEPrzesylki
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUrzedyWydajaceEPrzesylki $parameters
     * @return \StructType\GetUrzedyWydajaceEPrzesylkiResponse|bool
     */
    public function getUrzedyWydajaceEPrzesylki(\StructType\GetUrzedyWydajaceEPrzesylki $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUrzedyWydajaceEPrzesylki($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeStatus $parameters
     * @return \StructType\GetEnvelopeStatusResponse|bool
     */
    public function getEnvelopeStatus(\StructType\GetEnvelopeStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKarty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKarty $parameters
     * @return \StructType\GetKartyResponse|bool
     */
    public function getKarty(\StructType\GetKarty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKarty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPasswordExpiredDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPasswordExpiredDate $parameters
     * @return \StructType\GetPasswordExpiredDateResponse|bool
     */
    public function getPasswordExpiredDate(\StructType\GetPasswordExpiredDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPasswordExpiredDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeContentShort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeContentShort $parameters
     * @return \StructType\GetEnvelopeContentShortResponse|bool
     */
    public function getEnvelopeContentShort(\StructType\GetEnvelopeContentShort $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeContentShort($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeContentFull
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeContentFull $parameters
     * @return \StructType\GetEnvelopeContentFullResponse|bool
     */
    public function getEnvelopeContentFull(\StructType\GetEnvelopeContentFull $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeContentFull($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddressLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddressLabel $parameters
     * @return \StructType\GetAddressLabelResponse|bool
     */
    public function getAddressLabel(\StructType\GetAddressLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAddressLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOutboxBook
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOutboxBook $parameters
     * @return \StructType\GetOutboxBookResponse|bool
     */
    public function getOutboxBook(\StructType\GetOutboxBook $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOutboxBook($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFirmowaPocztaBook
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFirmowaPocztaBook $parameters
     * @return \StructType\GetFirmowaPocztaBookResponse|bool
     */
    public function getFirmowaPocztaBook(\StructType\GetFirmowaPocztaBook $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getFirmowaPocztaBook($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeList $parameters
     * @return \StructType\GetEnvelopeListResponse|bool
     */
    public function getEnvelopeList(\StructType\GetEnvelopeList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddresLabelByGuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddresLabelByGuid $parameters
     * @return \StructType\GetAddresLabelByGuidResponse|bool
     */
    public function getAddresLabelByGuid(\StructType\GetAddresLabelByGuid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAddresLabelByGuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPlacowkiPocztowe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPlacowkiPocztowe $parameters
     * @return \StructType\GetPlacowkiPocztoweResponse|bool
     */
    public function getPlacowkiPocztowe(\StructType\GetPlacowkiPocztowe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPlacowkiPocztowe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGuid $parameters
     * @return \StructType\GetGuidResponse|bool
     */
    public function getGuid(\StructType\GetGuid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKierunki
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKierunki $parameters
     * @return \StructType\GetKierunkiResponse|bool
     */
    public function getKierunki(\StructType\GetKierunki $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKierunki($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKierunkiInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKierunkiInfo $parameters
     * @return \StructType\GetKierunkiInfoResponse|bool
     */
    public function getKierunkiInfo(\StructType\GetKierunkiInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKierunkiInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeBufor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeBufor $parameters
     * @return \StructType\GetEnvelopeBuforResponse|bool
     */
    public function getEnvelopeBufor(\StructType\GetEnvelopeBufor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeBufor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEPOStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEPOStatus $parameters
     * @return \StructType\GetEPOStatusResponse|bool
     */
    public function getEPOStatus(\StructType\GetEPOStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEPOStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddresLabelCompact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddresLabelCompact $parameters
     * @return \StructType\GetAddresLabelCompactResponse|bool
     */
    public function getAddresLabelCompact(\StructType\GetAddresLabelCompact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAddresLabelCompact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddresLabelByGuidCompact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddresLabelByGuidCompact $parameters
     * @return \StructType\GetAddresLabelByGuidCompactResponse|bool
     */
    public function getAddresLabelByGuidCompact(\StructType\GetAddresLabelByGuidCompact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAddresLabelByGuidCompact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeBuforList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelopeBuforList $parameters
     * @return \StructType\GetEnvelopeBuforListResponse|bool
     */
    public function getEnvelopeBuforList(\StructType\GetEnvelopeBuforList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeBuforList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUbezpieczeniaInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUbezpieczeniaInfo $parameters
     * @return \StructType\GetUbezpieczeniaInfoResponse|bool
     */
    public function getUbezpieczeniaInfo(\StructType\GetUbezpieczeniaInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUbezpieczeniaInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlankietPobraniaByGuids
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBlankietPobraniaByGuids $parameters
     * @return \StructType\GetBlankietPobraniaByGuidsResponse|bool
     */
    public function getBlankietPobraniaByGuids(\StructType\GetBlankietPobraniaByGuids $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlankietPobraniaByGuids($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountList $parameters
     * @return \StructType\GetAccountListResponse|bool
     */
    public function getAccountList(\StructType\GetAccountList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProfilList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProfilList $parameters
     * @return \StructType\GetProfilListResponse|bool
     */
    public function getProfilList(\StructType\GetProfilList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getProfilList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReklamacje
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReklamacje $parameters
     * @return \StructType\GetReklamacjeResponse|bool
     */
    public function getReklamacje(\StructType\GetReklamacje $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReklamacje($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZapowiedziFaktur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetZapowiedziFaktur $parameters
     * @return \StructType\GetZapowiedziFakturResponse|bool
     */
    public function getZapowiedziFaktur(\StructType\GetZapowiedziFaktur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getZapowiedziFaktur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getListaPowodowReklamacji
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaPowodowReklamacji $parameters
     * @return \StructType\GetListaPowodowReklamacjiResponse|bool
     */
    public function getListaPowodowReklamacji(\StructType\GetListaPowodowReklamacji $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getListaPowodowReklamacji($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEZDO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEZDO $parameters
     * @return \StructType\GetEZDOResponse|bool
     */
    public function getEZDO(\StructType\GetEZDO $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEZDO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEZDOList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEZDOList $parameters
     * @return \StructType\GetEZDOListResponse|bool
     */
    public function getEZDOList(\StructType\GetEZDOList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEZDOList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWplatyCKP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWplatyCKP $parameters
     * @return \StructType\GetWplatyCKPResponse|bool
     */
    public function getWplatyCKP(\StructType\GetWplatyCKP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getWplatyCKP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getListaZgodEZwrotow
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaZgodEZwrotow $parameters
     * @return \StructType\GetListaZgodEZwrotowResponse|bool
     */
    public function getListaZgodEZwrotow(\StructType\GetListaZgodEZwrotow $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getListaZgodEZwrotow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPaczkaKorzysciInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPaczkaKorzysciInfo $parameters
     * @return \StructType\GetPaczkaKorzysciInfoResponse|bool
     */
    public function getPaczkaKorzysciInfo(\StructType\GetPaczkaKorzysciInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPaczkaKorzysciInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJednostkaOrganizacyjna
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetJednostkaOrganizacyjna $parameters
     * @return \StructType\GetJednostkaOrganizacyjnaResponse|bool
     */
    public function getJednostkaOrganizacyjna(\StructType\GetJednostkaOrganizacyjna $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getJednostkaOrganizacyjna($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrintForParcel
     * Meta information extracted from the WSDL
     * - documentation: The method returns parcels printouts for passed guid's
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPrintForParcel $parameters
     * @return \StructType\GetPrintForParcelResponse|bool
     */
    public function getPrintForParcel(\StructType\GetPrintForParcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPrintForParcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShopEZwrotyList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShopEZwrotyList $parameters
     * @return \StructType\GetShopEZwrotyListResponse|bool
     */
    public function getShopEZwrotyList(\StructType\GetShopEZwrotyList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getShopEZwrotyList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLibrariesForLegalDeposits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibrariesForLegalDeposits $parameters
     * @return \StructType\GetLibrariesForLegalDepositsResponse|bool
     */
    public function getLibrariesForLegalDeposits(\StructType\GetLibrariesForLegalDeposits $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLibrariesForLegalDeposits($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountListResponse|\StructType\GetAddresLabelByGuidCompactResponse|\StructType\GetAddresLabelByGuidResponse|\StructType\GetAddresLabelCompactResponse|\StructType\GetAddressLabelResponse|\StructType\GetBlankietPobraniaByGuidsResponse|\StructType\GetEnvelopeBuforListResponse|\StructType\GetEnvelopeBuforResponse|\StructType\GetEnvelopeContentFullResponse|\StructType\GetEnvelopeContentShortResponse|\StructType\GetEnvelopeListResponse|\StructType\GetEnvelopeStatusResponse|\StructType\GetEPOStatusResponse|\StructType\GetEZDOListResponse|\StructType\GetEZDOResponse|\StructType\GetFirmowaPocztaBookResponse|\StructType\GetGuidResponse|\StructType\GetJednostkaOrganizacyjnaResponse|\StructType\GetKartyResponse|\StructType\GetKierunkiInfoResponse|\StructType\GetKierunkiResponse|\StructType\GetLibrariesForLegalDepositsResponse|\StructType\GetListaPowodowReklamacjiResponse|\StructType\GetListaZgodEZwrotowResponse|\StructType\GetOutboxBookResponse|\StructType\GetPaczkaKorzysciInfoResponse|\StructType\GetPasswordExpiredDateResponse|\StructType\GetPlacowkiPocztoweResponse|\StructType\GetPrintForParcelResponse|\StructType\GetProfilListResponse|\StructType\GetReklamacjeResponse|\StructType\GetShopEZwrotyListResponse|\StructType\GetUbezpieczeniaInfoResponse|\StructType\GetUrzedyNadaniaResponse|\StructType\GetUrzedyWydajaceEPrzesylkiResponse|\StructType\GetWplatyCKPResponse|\StructType\GetZapowiedziFakturResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
