<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderEasyReturnSolutionLabel StructType
 * @subpackage Structs
 */
class OrderEasyReturnSolutionLabel extends AbstractStructBase
{
    /**
     * The senderAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressType
     */
    public $senderAddress;
    /**
     * The recipientAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressType
     */
    public $recipientAddress;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - documentation: Shipment weight [g].
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $weight;
    /**
     * The customsDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomsDeclarationType
     */
    public $customsDeclaration;
    /**
     * The deliveryMethod
     * Meta information extracted from the WSDL
     * - documentation: If not set, getPrintForParcel method should be used to get label.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeliveryMethodType
     */
    public $deliveryMethod;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Description. maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for orderEasyReturnSolutionLabel
     * @uses OrderEasyReturnSolutionLabel::setSenderAddress()
     * @uses OrderEasyReturnSolutionLabel::setRecipientAddress()
     * @uses OrderEasyReturnSolutionLabel::setWeight()
     * @uses OrderEasyReturnSolutionLabel::setCustomsDeclaration()
     * @uses OrderEasyReturnSolutionLabel::setDeliveryMethod()
     * @uses OrderEasyReturnSolutionLabel::setDescription()
     * @param \StructType\AddressType $senderAddress
     * @param \StructType\AddressType $recipientAddress
     * @param int $weight
     * @param \StructType\CustomsDeclarationType $customsDeclaration
     * @param \StructType\DeliveryMethodType $deliveryMethod
     * @param string $description
     */
    public function __construct(\StructType\AddressType $senderAddress = null, \StructType\AddressType $recipientAddress = null, $weight = null, \StructType\CustomsDeclarationType $customsDeclaration = null, \StructType\DeliveryMethodType $deliveryMethod = null, $description = null)
    {
        $this
            ->setSenderAddress($senderAddress)
            ->setRecipientAddress($recipientAddress)
            ->setWeight($weight)
            ->setCustomsDeclaration($customsDeclaration)
            ->setDeliveryMethod($deliveryMethod)
            ->setDescription($description);
    }
    /**
     * Get senderAddress value
     * @return \StructType\AddressType
     */
    public function getSenderAddress()
    {
        return $this->senderAddress;
    }
    /**
     * Set senderAddress value
     * @param \StructType\AddressType $senderAddress
     * @return \StructType\OrderEasyReturnSolutionLabel
     */
    public function setSenderAddress(\StructType\AddressType $senderAddress = null)
    {
        $this->senderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get recipientAddress value
     * @return \StructType\AddressType
     */
    public function getRecipientAddress()
    {
        return $this->recipientAddress;
    }
    /**
     * Set recipientAddress value
     * @param \StructType\AddressType $recipientAddress
     * @return \StructType\OrderEasyReturnSolutionLabel
     */
    public function setRecipientAddress(\StructType\AddressType $recipientAddress = null)
    {
        $this->recipientAddress = $recipientAddress;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return \StructType\OrderEasyReturnSolutionLabel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get customsDeclaration value
     * @return \StructType\CustomsDeclarationType|null
     */
    public function getCustomsDeclaration()
    {
        return $this->customsDeclaration;
    }
    /**
     * Set customsDeclaration value
     * @param \StructType\CustomsDeclarationType $customsDeclaration
     * @return \StructType\OrderEasyReturnSolutionLabel
     */
    public function setCustomsDeclaration(\StructType\CustomsDeclarationType $customsDeclaration = null)
    {
        $this->customsDeclaration = $customsDeclaration;
        return $this;
    }
    /**
     * Get deliveryMethod value
     * @return \StructType\DeliveryMethodType|null
     */
    public function getDeliveryMethod()
    {
        return $this->deliveryMethod;
    }
    /**
     * Set deliveryMethod value
     * @param \StructType\DeliveryMethodType $deliveryMethod
     * @return \StructType\OrderEasyReturnSolutionLabel
     */
    public function setDeliveryMethod(\StructType\DeliveryMethodType $deliveryMethod = null)
    {
        $this->deliveryMethod = $deliveryMethod;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\OrderEasyReturnSolutionLabel
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
