<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikWyszukiwaniaReceptUslugobiorcyMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Pojedynczy wynik wyszukiwania recepty usługobiorcy.
 * @subpackage Structs
 */
class WynikWyszukiwaniaReceptUslugobiorcyMT extends AbstractStructBase
{
    /**
     * The kluczRecepty
     * Meta information extracted from the WSDL
     * - documentation: Klucz recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kluczRecepty;
    /**
     * The kluczPakietu
     * Meta information extracted from the WSDL
     * - documentation: Klucz pakietu recept zawierającego recepty spełniające kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kluczPakietu;
    /**
     * The dataWystawieniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia recepty (przez datę wystawienia recepty rozumie się moment zapisu recepty w Systemie P1).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataWystawieniaRecepty;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusRecepty;
    /**
     * The podmiotNazwa
     * Meta information extracted from the WSDL
     * - documentation: Nazwa podmiotu wystawiającego receptę spełniającą kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $podmiotNazwa;
    /**
     * The wystawcaNazwa
     * Meta information extracted from the WSDL
     * - documentation: Nazwa wystawcy recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $wystawcaNazwa;
    /**
     * The identyfikatorPracownikaWystawcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator pracownika wystawcy recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorPracownikaMedycznegoOIDMT
     */
    public $identyfikatorPracownikaWystawcy;
    /**
     * The identyfikatorPodmiotuWystawcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator podmiotu wystawcy recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorPodmiotuOIDMT
     */
    public $identyfikatorPodmiotuWystawcy;
    /**
     * The przyczynaZablokowaniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Przyczyna zablokowania recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $przyczynaZablokowaniaRecepty;
    /**
     * Constructor method for WynikWyszukiwaniaReceptUslugobiorcyMT
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setKluczRecepty()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setKluczPakietu()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setDataWystawieniaRecepty()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setNumerRecepty()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setStatusRecepty()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setPodmiotNazwa()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setWystawcaNazwa()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setIdentyfikatorPracownikaWystawcy()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setIdentyfikatorPodmiotuWystawcy()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyMT::setPrzyczynaZablokowaniaRecepty()
     * @param string $kluczRecepty
     * @param string $kluczPakietu
     * @param string $dataWystawieniaRecepty
     * @param NumerReceptyOIDMT $numerRecepty
     * @param string $statusRecepty
     * @param string $podmiotNazwa
     * @param string $wystawcaNazwa
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaWystawcy
     * @param IdentyfikatorPodmiotuOIDMT $identyfikatorPodmiotuWystawcy
     * @param string $przyczynaZablokowaniaRecepty
     */
    public function __construct($kluczRecepty = null, $kluczPakietu = null, $dataWystawieniaRecepty = null, NumerReceptyOIDMT $numerRecepty = null, $statusRecepty = null, $podmiotNazwa = null, $wystawcaNazwa = null, IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaWystawcy = null, IdentyfikatorPodmiotuOIDMT $identyfikatorPodmiotuWystawcy = null, $przyczynaZablokowaniaRecepty = null)
    {
        $this
            ->setKluczRecepty($kluczRecepty)
            ->setKluczPakietu($kluczPakietu)
            ->setDataWystawieniaRecepty($dataWystawieniaRecepty)
            ->setNumerRecepty($numerRecepty)
            ->setStatusRecepty($statusRecepty)
            ->setPodmiotNazwa($podmiotNazwa)
            ->setWystawcaNazwa($wystawcaNazwa)
            ->setIdentyfikatorPracownikaWystawcy($identyfikatorPracownikaWystawcy)
            ->setIdentyfikatorPodmiotuWystawcy($identyfikatorPodmiotuWystawcy)
            ->setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty);
    }
    /**
     * Get kluczRecepty value
     * @return string
     */
    public function getKluczRecepty()
    {
        return $this->kluczRecepty;
    }
    /**
     * Set kluczRecepty value
     * @param string $kluczRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setKluczRecepty($kluczRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($kluczRecepty) && !is_string($kluczRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczRecepty, true), gettype($kluczRecepty)), __LINE__);
        }
        $this->kluczRecepty = $kluczRecepty;
        return $this;
    }
    /**
     * Get kluczPakietu value
     * @return string
     */
    public function getKluczPakietu()
    {
        return $this->kluczPakietu;
    }
    /**
     * Set kluczPakietu value
     * @param string $kluczPakietu
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setKluczPakietu($kluczPakietu = null)
    {
        // validation for constraint: string
        if (!is_null($kluczPakietu) && !is_string($kluczPakietu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczPakietu, true), gettype($kluczPakietu)), __LINE__);
        }
        $this->kluczPakietu = $kluczPakietu;
        return $this;
    }
    /**
     * Get dataWystawieniaRecepty value
     * @return string
     */
    public function getDataWystawieniaRecepty()
    {
        return $this->dataWystawieniaRecepty;
    }
    /**
     * Set dataWystawieniaRecepty value
     * @param string $dataWystawieniaRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setDataWystawieniaRecepty($dataWystawieniaRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaRecepty) && !is_string($dataWystawieniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaRecepty, true), gettype($dataWystawieniaRecepty)), __LINE__);
        }
        $this->dataWystawieniaRecepty = $dataWystawieniaRecepty;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
    /**
     * Get statusRecepty value
     * @return string
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
    /**
     * Get podmiotNazwa value
     * @return string
     */
    public function getPodmiotNazwa()
    {
        return $this->podmiotNazwa;
    }
    /**
     * Set podmiotNazwa value
     * @param string $podmiotNazwa
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setPodmiotNazwa($podmiotNazwa = null)
    {
        // validation for constraint: string
        if (!is_null($podmiotNazwa) && !is_string($podmiotNazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podmiotNazwa, true), gettype($podmiotNazwa)), __LINE__);
        }
        $this->podmiotNazwa = $podmiotNazwa;
        return $this;
    }
    /**
     * Get wystawcaNazwa value
     * @return string
     */
    public function getWystawcaNazwa()
    {
        return $this->wystawcaNazwa;
    }
    /**
     * Set wystawcaNazwa value
     * @param string $wystawcaNazwa
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setWystawcaNazwa($wystawcaNazwa = null)
    {
        // validation for constraint: string
        if (!is_null($wystawcaNazwa) && !is_string($wystawcaNazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wystawcaNazwa, true), gettype($wystawcaNazwa)), __LINE__);
        }
        $this->wystawcaNazwa = $wystawcaNazwa;
        return $this;
    }
    /**
     * Get identyfikatorPracownikaWystawcy value
     * @return IdentyfikatorPracownikaMedycznegoOIDMT
     */
    public function getIdentyfikatorPracownikaWystawcy()
    {
        return $this->identyfikatorPracownikaWystawcy;
    }
    /**
     * Set identyfikatorPracownikaWystawcy value
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaWystawcy
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setIdentyfikatorPracownikaWystawcy(IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaWystawcy = null)
    {
        $this->identyfikatorPracownikaWystawcy = $identyfikatorPracownikaWystawcy;
        return $this;
    }
    /**
     * Get identyfikatorPodmiotuWystawcy value
     * @return IdentyfikatorPodmiotuOIDMT
     */
    public function getIdentyfikatorPodmiotuWystawcy()
    {
        return $this->identyfikatorPodmiotuWystawcy;
    }
    /**
     * Set identyfikatorPodmiotuWystawcy value
     * @param IdentyfikatorPodmiotuOIDMT $identyfikatorPodmiotuWystawcy
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setIdentyfikatorPodmiotuWystawcy(IdentyfikatorPodmiotuOIDMT $identyfikatorPodmiotuWystawcy = null)
    {
        $this->identyfikatorPodmiotuWystawcy = $identyfikatorPodmiotuWystawcy;
        return $this;
    }
    /**
     * Get przyczynaZablokowaniaRecepty value
     * @return string|null
     */
    public function getPrzyczynaZablokowaniaRecepty()
    {
        return $this->przyczynaZablokowaniaRecepty;
    }
    /**
     * Set przyczynaZablokowaniaRecepty value
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid()
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $przyczynaZablokowaniaRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty = null)
    {
        // validation for constraint: enumeration
        if (!PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid($przyczynaZablokowaniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrzyczynaZablokowaniaReceptyEnumMT', is_array($przyczynaZablokowaniaRecepty) ? implode(', ', $przyczynaZablokowaniaRecepty) : var_export($przyczynaZablokowaniaRecepty, true), implode(', ', PrzyczynaZablokowaniaReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->przyczynaZablokowaniaRecepty = $przyczynaZablokowaniaRecepty;
        return $this;
    }
}
