<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Pojedynczy wynik wyszukiwania recepty usługobiorcy do konsultacji.
 * @subpackage Structs
 */
class WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT extends AbstractStructBase
{
    /**
     * The dataWystawieniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia recepty (przez datę wystawienia recepty rozumie się moment zapisu recepty w Systemie P1).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataWystawieniaRecepty;
    /**
     * The identyfikatorPodmiotuWystawcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator podmiotu wystawcy dokumentu recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorPodmiotuOIDMT
     */
    public $identyfikatorPodmiotuWystawcy;
    /**
     * The identyfikatorPracownikaWystawcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator pracownika medycznego wystawcy dokumentu recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorPracownikaMedycznegoOIDMT
     */
    public $identyfikatorPracownikaWystawcy;
    /**
     * The lekNazwa
     * Meta information extracted from the WSDL
     * - documentation: Nazwa leku w recepcie
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lekNazwa;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty nadany przez usługodawcę wystawiającego receptę.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * The podmiotNazwa
     * Meta information extracted from the WSDL
     * - documentation: Nazwa podmiotu wystawcy dokumentu recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $podmiotNazwa;
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusRecepty;
    /**
     * The wystawcaNazwa
     * Meta information extracted from the WSDL
     * - documentation: Imię, nazwisko pracownika medycznego wystawiajacego receptę.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $wystawcaNazwa;
    /**
     * The przyczynaZablokowaniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Przyczyna zablokowania recepty
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $przyczynaZablokowaniaRecepty;
    /**
     * Constructor method for WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setDataWystawieniaRecepty()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setIdentyfikatorPodmiotuWystawcy()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setIdentyfikatorPracownikaWystawcy()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setLekNazwa()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setNumerRecepty()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setPodmiotNazwa()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setStatusRecepty()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setWystawcaNazwa()
     * @uses WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT::setPrzyczynaZablokowaniaRecepty()
     * @param string $dataWystawieniaRecepty
     * @param IdentyfikatorPodmiotuOIDMT $identyfikatorPodmiotuWystawcy
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaWystawcy
     * @param string $lekNazwa
     * @param NumerReceptyOIDMT $numerRecepty
     * @param string $podmiotNazwa
     * @param string $statusRecepty
     * @param string $wystawcaNazwa
     * @param string $przyczynaZablokowaniaRecepty
     */
    public function __construct($dataWystawieniaRecepty = null, IdentyfikatorPodmiotuOIDMT $identyfikatorPodmiotuWystawcy = null, IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaWystawcy = null, $lekNazwa = null, NumerReceptyOIDMT $numerRecepty = null, $podmiotNazwa = null, $statusRecepty = null, $wystawcaNazwa = null, $przyczynaZablokowaniaRecepty = null)
    {
        $this
            ->setDataWystawieniaRecepty($dataWystawieniaRecepty)
            ->setIdentyfikatorPodmiotuWystawcy($identyfikatorPodmiotuWystawcy)
            ->setIdentyfikatorPracownikaWystawcy($identyfikatorPracownikaWystawcy)
            ->setLekNazwa($lekNazwa)
            ->setNumerRecepty($numerRecepty)
            ->setPodmiotNazwa($podmiotNazwa)
            ->setStatusRecepty($statusRecepty)
            ->setWystawcaNazwa($wystawcaNazwa)
            ->setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty);
    }
    /**
     * Get dataWystawieniaRecepty value
     * @return string
     */
    public function getDataWystawieniaRecepty()
    {
        return $this->dataWystawieniaRecepty;
    }
    /**
     * Set dataWystawieniaRecepty value
     * @param string $dataWystawieniaRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setDataWystawieniaRecepty($dataWystawieniaRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaRecepty) && !is_string($dataWystawieniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaRecepty, true), gettype($dataWystawieniaRecepty)), __LINE__);
        }
        $this->dataWystawieniaRecepty = $dataWystawieniaRecepty;
        return $this;
    }
    /**
     * Get identyfikatorPodmiotuWystawcy value
     * @return IdentyfikatorPodmiotuOIDMT
     */
    public function getIdentyfikatorPodmiotuWystawcy()
    {
        return $this->identyfikatorPodmiotuWystawcy;
    }
    /**
     * Set identyfikatorPodmiotuWystawcy value
     * @param IdentyfikatorPodmiotuOIDMT $identyfikatorPodmiotuWystawcy
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setIdentyfikatorPodmiotuWystawcy(IdentyfikatorPodmiotuOIDMT $identyfikatorPodmiotuWystawcy = null)
    {
        $this->identyfikatorPodmiotuWystawcy = $identyfikatorPodmiotuWystawcy;
        return $this;
    }
    /**
     * Get identyfikatorPracownikaWystawcy value
     * @return IdentyfikatorPracownikaMedycznegoOIDMT
     */
    public function getIdentyfikatorPracownikaWystawcy()
    {
        return $this->identyfikatorPracownikaWystawcy;
    }
    /**
     * Set identyfikatorPracownikaWystawcy value
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaWystawcy
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setIdentyfikatorPracownikaWystawcy(IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaWystawcy = null)
    {
        $this->identyfikatorPracownikaWystawcy = $identyfikatorPracownikaWystawcy;
        return $this;
    }
    /**
     * Get lekNazwa value
     * @return string
     */
    public function getLekNazwa()
    {
        return $this->lekNazwa;
    }
    /**
     * Set lekNazwa value
     * @param string $lekNazwa
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setLekNazwa($lekNazwa = null)
    {
        // validation for constraint: string
        if (!is_null($lekNazwa) && !is_string($lekNazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lekNazwa, true), gettype($lekNazwa)), __LINE__);
        }
        $this->lekNazwa = $lekNazwa;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
    /**
     * Get podmiotNazwa value
     * @return string
     */
    public function getPodmiotNazwa()
    {
        return $this->podmiotNazwa;
    }
    /**
     * Set podmiotNazwa value
     * @param string $podmiotNazwa
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setPodmiotNazwa($podmiotNazwa = null)
    {
        // validation for constraint: string
        if (!is_null($podmiotNazwa) && !is_string($podmiotNazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podmiotNazwa, true), gettype($podmiotNazwa)), __LINE__);
        }
        $this->podmiotNazwa = $podmiotNazwa;
        return $this;
    }
    /**
     * Get statusRecepty value
     * @return string
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
    /**
     * Get wystawcaNazwa value
     * @return string
     */
    public function getWystawcaNazwa()
    {
        return $this->wystawcaNazwa;
    }
    /**
     * Set wystawcaNazwa value
     * @param string $wystawcaNazwa
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setWystawcaNazwa($wystawcaNazwa = null)
    {
        // validation for constraint: string
        if (!is_null($wystawcaNazwa) && !is_string($wystawcaNazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wystawcaNazwa, true), gettype($wystawcaNazwa)), __LINE__);
        }
        $this->wystawcaNazwa = $wystawcaNazwa;
        return $this;
    }
    /**
     * Get przyczynaZablokowaniaRecepty value
     * @return string|null
     */
    public function getPrzyczynaZablokowaniaRecepty()
    {
        return $this->przyczynaZablokowaniaRecepty;
    }
    /**
     * Set przyczynaZablokowaniaRecepty value
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid()
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $przyczynaZablokowaniaRecepty
     * @return WynikWyszukiwaniaReceptUslugobiorcyDoKonsultacjiMT
     */
    public function setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty = null)
    {
        // validation for constraint: enumeration
        if (!PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid($przyczynaZablokowaniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrzyczynaZablokowaniaReceptyEnumMT', is_array($przyczynaZablokowaniaRecepty) ? implode(', ', $przyczynaZablokowaniaRecepty) : var_export($przyczynaZablokowaniaRecepty, true), implode(', ', PrzyczynaZablokowaniaReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->przyczynaZablokowaniaRecepty = $przyczynaZablokowaniaRecepty;
        return $this;
    }
}
