<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikWyszukiwaniaDokumentowRealizacjiMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Pojedynczy wynik wyszukiwania spełniający kryteria wyszukiwania dokumentów realizacji recept.
 * @subpackage Structs
 */
class WynikWyszukiwaniaDokumentowRealizacjiMT extends AbstractStructBase
{
    /**
     * The identyfikatorDokumentuRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator dokumentu realizacji recepty - będący analogicznym odpowiednikiem numeru recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorDokumentuOIDMT
     */
    public $identyfikatorDokumentuRealizacjiRecepty;
    /**
     * The statusDokumentuRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status dokumentu realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusDokumentuRealizacjiRecepty;
    /**
     * The rodzajRealizacji
     * Meta information extracted from the WSDL
     * - documentation: Rodzaj realizacji.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rodzajRealizacji;
    /**
     * The dataWystawienia
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataWystawienia;
    /**
     * The identyfikatorPracownikaRealizatora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator pracownika (farmaceuta, technik farmaceuta) podmiotu realizatora odpowiedzialnego za wystawienie dokumentu realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorPracownikaMedycznegoOIDMT
     */
    public $identyfikatorPracownikaRealizatora;
    /**
     * The identyfikatorPodmiotuWystawcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator podmiotu wystawcy dokumentu recepty związanego z wyszukiwanym dokumentem realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var IdentyfikatorUslugodawcyOIDMT
     */
    public $identyfikatorPodmiotuWystawcy;
    /**
     * The kluczRecepty
     * Meta information extracted from the WSDL
     * - documentation: Klucz dokumentu recepty, którego dotyczy wyszukiwany dokument realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kluczRecepty;
    /**
     * The numerReceptyPapierowej
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty papierowej, która w czasie wystawiania nie jest rejestrowana w systemie P1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numerReceptyPapierowej;
    /**
     * The numerPozycjiReceptyPapierowej
     * Meta information extracted from the WSDL
     * - documentation: Numer pozycji na recepcie papierowej, która w czasie wystawiania nie jest rejestrowana w systemie P1. Jeśli wynik wyszukiwania dot. dokumentu realizacji, który wskazuje na receptę papierową, to w atrybucie
     * numerPozycjaReceptyPapierowej wskazany zostanie numer konkretnej pozycji recepty papierowej, której dotyczy dokument realizacji.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numerPozycjiReceptyPapierowej;
    /**
     * Constructor method for WynikWyszukiwaniaDokumentowRealizacjiMT
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setIdentyfikatorDokumentuRealizacjiRecepty()
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setStatusDokumentuRealizacjiRecepty()
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setRodzajRealizacji()
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setDataWystawienia()
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setIdentyfikatorPracownikaRealizatora()
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setIdentyfikatorPodmiotuWystawcy()
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setKluczRecepty()
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setNumerReceptyPapierowej()
     * @uses WynikWyszukiwaniaDokumentowRealizacjiMT::setNumerPozycjiReceptyPapierowej()
     * @param IdentyfikatorDokumentuOIDMT $identyfikatorDokumentuRealizacjiRecepty
     * @param string $statusDokumentuRealizacjiRecepty
     * @param string $rodzajRealizacji
     * @param string $dataWystawienia
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaRealizatora
     * @param IdentyfikatorUslugodawcyOIDMT $identyfikatorPodmiotuWystawcy
     * @param string $kluczRecepty
     * @param string $numerReceptyPapierowej
     * @param int $numerPozycjiReceptyPapierowej
     */
    public function __construct(IdentyfikatorDokumentuOIDMT $identyfikatorDokumentuRealizacjiRecepty = null, $statusDokumentuRealizacjiRecepty = null, $rodzajRealizacji = null, $dataWystawienia = null, IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaRealizatora = null, IdentyfikatorUslugodawcyOIDMT $identyfikatorPodmiotuWystawcy = null, $kluczRecepty = null, $numerReceptyPapierowej = null, $numerPozycjiReceptyPapierowej = null)
    {
        $this
            ->setIdentyfikatorDokumentuRealizacjiRecepty($identyfikatorDokumentuRealizacjiRecepty)
            ->setStatusDokumentuRealizacjiRecepty($statusDokumentuRealizacjiRecepty)
            ->setRodzajRealizacji($rodzajRealizacji)
            ->setDataWystawienia($dataWystawienia)
            ->setIdentyfikatorPracownikaRealizatora($identyfikatorPracownikaRealizatora)
            ->setIdentyfikatorPodmiotuWystawcy($identyfikatorPodmiotuWystawcy)
            ->setKluczRecepty($kluczRecepty)
            ->setNumerReceptyPapierowej($numerReceptyPapierowej)
            ->setNumerPozycjiReceptyPapierowej($numerPozycjiReceptyPapierowej);
    }
    /**
     * Get identyfikatorDokumentuRealizacjiRecepty value
     * @return IdentyfikatorDokumentuOIDMT
     */
    public function getIdentyfikatorDokumentuRealizacjiRecepty()
    {
        return $this->identyfikatorDokumentuRealizacjiRecepty;
    }
    /**
     * Set identyfikatorDokumentuRealizacjiRecepty value
     * @param IdentyfikatorDokumentuOIDMT $identyfikatorDokumentuRealizacjiRecepty
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setIdentyfikatorDokumentuRealizacjiRecepty(IdentyfikatorDokumentuOIDMT $identyfikatorDokumentuRealizacjiRecepty = null)
    {
        $this->identyfikatorDokumentuRealizacjiRecepty = $identyfikatorDokumentuRealizacjiRecepty;
        return $this;
    }
    /**
     * Get statusDokumentuRealizacjiRecepty value
     * @return string
     */
    public function getStatusDokumentuRealizacjiRecepty()
    {
        return $this->statusDokumentuRealizacjiRecepty;
    }
    /**
     * Set statusDokumentuRealizacjiRecepty value
     * @uses StatusDokumentuRealizacjiReceptyEnumMT::valueIsValid()
     * @uses StatusDokumentuRealizacjiReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusDokumentuRealizacjiRecepty
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setStatusDokumentuRealizacjiRecepty($statusDokumentuRealizacjiRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusDokumentuRealizacjiReceptyEnumMT::valueIsValid($statusDokumentuRealizacjiRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusDokumentuRealizacjiReceptyEnumMT', is_array($statusDokumentuRealizacjiRecepty) ? implode(', ', $statusDokumentuRealizacjiRecepty) : var_export($statusDokumentuRealizacjiRecepty, true), implode(', ', StatusDokumentuRealizacjiReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusDokumentuRealizacjiRecepty = $statusDokumentuRealizacjiRecepty;
        return $this;
    }
    /**
     * Get rodzajRealizacji value
     * @return string
     */
    public function getRodzajRealizacji()
    {
        return $this->rodzajRealizacji;
    }
    /**
     * Set rodzajRealizacji value
     * @uses RodzajRealizacjiEnumMT::valueIsValid()
     * @uses RodzajRealizacjiEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rodzajRealizacji
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setRodzajRealizacji($rodzajRealizacji = null)
    {
        // validation for constraint: enumeration
        if (!RodzajRealizacjiEnumMT::valueIsValid($rodzajRealizacji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class RodzajRealizacjiEnumMT', is_array($rodzajRealizacji) ? implode(', ', $rodzajRealizacji) : var_export($rodzajRealizacji, true), implode(', ', RodzajRealizacjiEnumMT::getValidValues())), __LINE__);
        }
        $this->rodzajRealizacji = $rodzajRealizacji;
        return $this;
    }
    /**
     * Get dataWystawienia value
     * @return string
     */
    public function getDataWystawienia()
    {
        return $this->dataWystawienia;
    }
    /**
     * Set dataWystawienia value
     * @param string $dataWystawienia
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setDataWystawienia($dataWystawienia = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawienia) && !is_string($dataWystawienia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawienia, true), gettype($dataWystawienia)), __LINE__);
        }
        $this->dataWystawienia = $dataWystawienia;
        return $this;
    }
    /**
     * Get identyfikatorPracownikaRealizatora value
     * @return IdentyfikatorPracownikaMedycznegoOIDMT
     */
    public function getIdentyfikatorPracownikaRealizatora()
    {
        return $this->identyfikatorPracownikaRealizatora;
    }
    /**
     * Set identyfikatorPracownikaRealizatora value
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaRealizatora
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setIdentyfikatorPracownikaRealizatora(IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaRealizatora = null)
    {
        $this->identyfikatorPracownikaRealizatora = $identyfikatorPracownikaRealizatora;
        return $this;
    }
    /**
     * Get identyfikatorPodmiotuWystawcy value
     * @return IdentyfikatorUslugodawcyOIDMT|null
     */
    public function getIdentyfikatorPodmiotuWystawcy()
    {
        return $this->identyfikatorPodmiotuWystawcy;
    }
    /**
     * Set identyfikatorPodmiotuWystawcy value
     * @param IdentyfikatorUslugodawcyOIDMT $identyfikatorPodmiotuWystawcy
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setIdentyfikatorPodmiotuWystawcy(IdentyfikatorUslugodawcyOIDMT $identyfikatorPodmiotuWystawcy = null)
    {
        $this->identyfikatorPodmiotuWystawcy = $identyfikatorPodmiotuWystawcy;
        return $this;
    }
    /**
     * Get kluczRecepty value
     * @return string|null
     */
    public function getKluczRecepty()
    {
        return $this->kluczRecepty;
    }
    /**
     * Set kluczRecepty value
     * @param string $kluczRecepty
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setKluczRecepty($kluczRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($kluczRecepty) && !is_string($kluczRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczRecepty, true), gettype($kluczRecepty)), __LINE__);
        }
        $this->kluczRecepty = $kluczRecepty;
        return $this;
    }
    /**
     * Get numerReceptyPapierowej value
     * @return string|null
     */
    public function getNumerReceptyPapierowej()
    {
        return $this->numerReceptyPapierowej;
    }
    /**
     * Set numerReceptyPapierowej value
     * @param string $numerReceptyPapierowej
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setNumerReceptyPapierowej($numerReceptyPapierowej = null)
    {
        // validation for constraint: string
        if (!is_null($numerReceptyPapierowej) && !is_string($numerReceptyPapierowej)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerReceptyPapierowej, true), gettype($numerReceptyPapierowej)), __LINE__);
        }
        $this->numerReceptyPapierowej = $numerReceptyPapierowej;
        return $this;
    }
    /**
     * Get numerPozycjiReceptyPapierowej value
     * @return int|null
     */
    public function getNumerPozycjiReceptyPapierowej()
    {
        return $this->numerPozycjiReceptyPapierowej;
    }
    /**
     * Set numerPozycjiReceptyPapierowej value
     * @param int $numerPozycjiReceptyPapierowej
     * @return WynikWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setNumerPozycjiReceptyPapierowej($numerPozycjiReceptyPapierowej = null)
    {
        // validation for constraint: int
        if (!is_null($numerPozycjiReceptyPapierowej) && !(is_int($numerPozycjiReceptyPapierowej) || ctype_digit($numerPozycjiReceptyPapierowej))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numerPozycjiReceptyPapierowej, true), gettype($numerPozycjiReceptyPapierowej)), __LINE__);
        }
        $this->numerPozycjiReceptyPapierowej = $numerPozycjiReceptyPapierowej;
        return $this;
    }
}
