<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikOdczytuReceptyDoKonsultacjiMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Wynik udostępnienia recepty usługobiorcy do konsultacji (recepta + dokument weryfikacji).
 * @subpackage Structs
 */
class WynikOdczytuReceptyDoKonsultacjiMT extends AbstractStructBase
{
    /**
     * The dokumentRecepty
     * Meta information extracted from the WSDL
     * - documentation: Zaszyfrowany dokument recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dokumentRecepty;
    /**
     * The przyczynaZablokowaniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Przyczyna zablokowania recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $przyczynaZablokowaniaRecepty;
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusRecepty;
    /**
     * The DaneRealizacjiDoKonsultacjiMT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DaneRealizacjiDoKonsultacjiMT[]
     */
    public $DaneRealizacjiDoKonsultacjiMT;
    /**
     * Constructor method for WynikOdczytuReceptyDoKonsultacjiMT
     * @uses WynikOdczytuReceptyDoKonsultacjiMT::setDokumentRecepty()
     * @uses WynikOdczytuReceptyDoKonsultacjiMT::setPrzyczynaZablokowaniaRecepty()
     * @uses WynikOdczytuReceptyDoKonsultacjiMT::setStatusRecepty()
     * @uses WynikOdczytuReceptyDoKonsultacjiMT::setDaneRealizacjiDoKonsultacjiMT()
     * @param string $dokumentRecepty
     * @param string $przyczynaZablokowaniaRecepty
     * @param string $statusRecepty
     * @param DaneRealizacjiDoKonsultacjiMT[] $daneRealizacjiDoKonsultacjiMT
     */
    public function __construct($dokumentRecepty = null, $przyczynaZablokowaniaRecepty = null, $statusRecepty = null, array $daneRealizacjiDoKonsultacjiMT = array())
    {
        $this
            ->setDokumentRecepty($dokumentRecepty)
            ->setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty)
            ->setStatusRecepty($statusRecepty)
            ->setDaneRealizacjiDoKonsultacjiMT($daneRealizacjiDoKonsultacjiMT);
    }
    /**
     * Get dokumentRecepty value
     * @return string|null
     */
    public function getDokumentRecepty()
    {
        return $this->dokumentRecepty;
    }
    /**
     * Set dokumentRecepty value
     * @param string $dokumentRecepty
     * @return WynikOdczytuReceptyDoKonsultacjiMT
     */
    public function setDokumentRecepty($dokumentRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($dokumentRecepty) && !is_string($dokumentRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dokumentRecepty, true), gettype($dokumentRecepty)), __LINE__);
        }
        $this->dokumentRecepty = $dokumentRecepty;
        return $this;
    }
    /**
     * Get przyczynaZablokowaniaRecepty value
     * @return string|null
     */
    public function getPrzyczynaZablokowaniaRecepty()
    {
        return $this->przyczynaZablokowaniaRecepty;
    }
    /**
     * Set przyczynaZablokowaniaRecepty value
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid()
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $przyczynaZablokowaniaRecepty
     * @return WynikOdczytuReceptyDoKonsultacjiMT
     */
    public function setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty = null)
    {
        // validation for constraint: enumeration
        if (!PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid($przyczynaZablokowaniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrzyczynaZablokowaniaReceptyEnumMT', is_array($przyczynaZablokowaniaRecepty) ? implode(', ', $przyczynaZablokowaniaRecepty) : var_export($przyczynaZablokowaniaRecepty, true), implode(', ', PrzyczynaZablokowaniaReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->przyczynaZablokowaniaRecepty = $przyczynaZablokowaniaRecepty;
        return $this;
    }
    /**
     * Get statusRecepty value
     * @return string|null
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return WynikOdczytuReceptyDoKonsultacjiMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
    /**
     * Get DaneRealizacjiDoKonsultacjiMT value
     * @return DaneRealizacjiDoKonsultacjiMT[]|null
     */
    public function getDaneRealizacjiDoKonsultacjiMT()
    {
        return $this->DaneRealizacjiDoKonsultacjiMT;
    }
    /**
     * This method is responsible for validating the values passed to the setDaneRealizacjiDoKonsultacjiMT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDaneRealizacjiDoKonsultacjiMT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDaneRealizacjiDoKonsultacjiMTForArrayConstraintsFromSetDaneRealizacjiDoKonsultacjiMT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $wynikOdczytuReceptyDoKonsultacjiMTDaneRealizacjiDoKonsultacjiMTItem) {
            // validation for constraint: itemType
            if (!$wynikOdczytuReceptyDoKonsultacjiMTDaneRealizacjiDoKonsultacjiMTItem instanceof DaneRealizacjiDoKonsultacjiMT) {
                $invalidValues[] = is_object($wynikOdczytuReceptyDoKonsultacjiMTDaneRealizacjiDoKonsultacjiMTItem) ? get_class($wynikOdczytuReceptyDoKonsultacjiMTDaneRealizacjiDoKonsultacjiMTItem) : sprintf('%s(%s)', gettype($wynikOdczytuReceptyDoKonsultacjiMTDaneRealizacjiDoKonsultacjiMTItem), var_export($wynikOdczytuReceptyDoKonsultacjiMTDaneRealizacjiDoKonsultacjiMTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DaneRealizacjiDoKonsultacjiMT property can only contain items of type DaneRealizacjiDoKonsultacjiMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DaneRealizacjiDoKonsultacjiMT value
     * @throws \InvalidArgumentException
     * @param DaneRealizacjiDoKonsultacjiMT[] $daneRealizacjiDoKonsultacjiMT
     * @return WynikOdczytuReceptyDoKonsultacjiMT
     */
    public function setDaneRealizacjiDoKonsultacjiMT(array $daneRealizacjiDoKonsultacjiMT = array())
    {
        // validation for constraint: array
        if ('' !== ($daneRealizacjiDoKonsultacjiMTArrayErrorMessage = self::validateDaneRealizacjiDoKonsultacjiMTForArrayConstraintsFromSetDaneRealizacjiDoKonsultacjiMT($daneRealizacjiDoKonsultacjiMT))) {
            throw new \InvalidArgumentException($daneRealizacjiDoKonsultacjiMTArrayErrorMessage, __LINE__);
        }
        $this->DaneRealizacjiDoKonsultacjiMT = $daneRealizacjiDoKonsultacjiMT;
        return $this;
    }
    /**
     * Add item to DaneRealizacjiDoKonsultacjiMT value
     * @throws \InvalidArgumentException
     * @param DaneRealizacjiDoKonsultacjiMT $item
     * @return WynikOdczytuReceptyDoKonsultacjiMT
     */
    public function addToDaneRealizacjiDoKonsultacjiMT(DaneRealizacjiDoKonsultacjiMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DaneRealizacjiDoKonsultacjiMT) {
            throw new \InvalidArgumentException(sprintf('The DaneRealizacjiDoKonsultacjiMT property can only contain items of type DaneRealizacjiDoKonsultacjiMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DaneRealizacjiDoKonsultacjiMT[] = $item;
        return $this;
    }
}
