<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Weryfikacja ServiceType
 * @subpackage Services
 */
class Weryfikacja extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20170510', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named weryfikacjaPakietuRecept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Weryfikacja listy recept elektronicznych w systemie. Parametry wejściowe to recepty w formacie HL7 CDA (bez podpisu elektronicznego). Wynikiem jest identyfikator zadania uruchomionego w P1 (w przypadku gdy operacja nie mogła być
     * zakończona synchronicznie) albo wyniki weryfikacji każdej z przekazanych recept.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param WeryfikacjaPakietuReceptRequest $weryfikacjaPakietuRecept
     * @return WeryfikacjaPakietuReceptResponse|bool
     */
    public function weryfikacjaPakietuRecept(WeryfikacjaPakietuReceptRequest $weryfikacjaPakietuRecept)
    {
        try {
            $this->setResult($this->getSoapClient()->weryfikacjaPakietuRecept($weryfikacjaPakietuRecept));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return WeryfikacjaPakietuReceptResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
