<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Kryteria wyszukiwania recept dla operacji rozszerzonego wyszukiwania recept.
 * @subpackage Structs
 */
class RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT extends AbstractStructBase
{
    /**
     * The idUslugobiorcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator usługobiorcy, dla którego zostały wystawione recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorUslugobiorcyOIDMT
     */
    public $idUslugobiorcy;
    /**
     * The dataWystawieniaReceptyDo
     * Meta information extracted from the WSDL
     * - documentation: Górne ograniczenie daty wystawienia recepty - data do kiedy wystawione mają być poszukiwane recepty. Wartość w tym polu musi być nie mniejsza niż data podana w dolnym ograniczeniu daty wystawienia recepty (o ile podano dolne
     * ograniczenie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaReceptyDo;
    /**
     * The dataWystawieniaReceptyOd
     * Meta information extracted from the WSDL
     * - documentation: Dolne ograniczenie daty wystawienia recepty - data od kiedy wystawione mają być poszukiwane recepty. Wartość w tym polu musi być nie większa niż data podana w górnym ograniczeniu daty wystawienia recepty (o ile podano górne
     * ograniczenie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaReceptyOd;
    /**
     * The nazwaLeku
     * Meta information extracted from the WSDL
     * - documentation: Nazwa leku.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nazwaLeku;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty nadany przez usługodawcę wystawiającego receptę.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status recepty, który aktualnie posiadają wyszukiwane recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusRecepty;
    /**
     * The parametryStronicowania
     * Meta information extracted from the WSDL
     * - documentation: Parametry stronicowania.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ParametryStronicowaniaMT
     */
    public $parametryStronicowania;
    /**
     * The czySytuacjaZagrozeniaZycia
     * Meta information extracted from the WSDL
     * - documentation: Flaga określająca wyszukiwanie recept w trybie "Sytuacji zagrożenia życia"
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $czySytuacjaZagrozeniaZycia;
    /**
     * Constructor method for RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     * @uses RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT::setIdUslugobiorcy()
     * @uses RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT::setDataWystawieniaReceptyDo()
     * @uses RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT::setDataWystawieniaReceptyOd()
     * @uses RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT::setNazwaLeku()
     * @uses RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT::setNumerRecepty()
     * @uses RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT::setStatusRecepty()
     * @uses RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT::setParametryStronicowania()
     * @uses RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT::setCzySytuacjaZagrozeniaZycia()
     * @param IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy
     * @param string $dataWystawieniaReceptyDo
     * @param string $dataWystawieniaReceptyOd
     * @param string $nazwaLeku
     * @param NumerReceptyOIDMT $numerRecepty
     * @param string $statusRecepty
     * @param ParametryStronicowaniaMT $parametryStronicowania
     * @param bool $czySytuacjaZagrozeniaZycia
     */
    public function __construct(IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy = null, $dataWystawieniaReceptyDo = null, $dataWystawieniaReceptyOd = null, $nazwaLeku = null, NumerReceptyOIDMT $numerRecepty = null, $statusRecepty = null, ParametryStronicowaniaMT $parametryStronicowania = null, $czySytuacjaZagrozeniaZycia = null)
    {
        $this
            ->setIdUslugobiorcy($idUslugobiorcy)
            ->setDataWystawieniaReceptyDo($dataWystawieniaReceptyDo)
            ->setDataWystawieniaReceptyOd($dataWystawieniaReceptyOd)
            ->setNazwaLeku($nazwaLeku)
            ->setNumerRecepty($numerRecepty)
            ->setStatusRecepty($statusRecepty)
            ->setParametryStronicowania($parametryStronicowania)
            ->setCzySytuacjaZagrozeniaZycia($czySytuacjaZagrozeniaZycia);
    }
    /**
     * Get idUslugobiorcy value
     * @return IdentyfikatorUslugobiorcyOIDMT
     */
    public function getIdUslugobiorcy()
    {
        return $this->idUslugobiorcy;
    }
    /**
     * Set idUslugobiorcy value
     * @param IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy
     * @return RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setIdUslugobiorcy(IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy = null)
    {
        $this->idUslugobiorcy = $idUslugobiorcy;
        return $this;
    }
    /**
     * Get dataWystawieniaReceptyDo value
     * @return string|null
     */
    public function getDataWystawieniaReceptyDo()
    {
        return $this->dataWystawieniaReceptyDo;
    }
    /**
     * Set dataWystawieniaReceptyDo value
     * @param string $dataWystawieniaReceptyDo
     * @return RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setDataWystawieniaReceptyDo($dataWystawieniaReceptyDo = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaReceptyDo) && !is_string($dataWystawieniaReceptyDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaReceptyDo, true), gettype($dataWystawieniaReceptyDo)), __LINE__);
        }
        $this->dataWystawieniaReceptyDo = $dataWystawieniaReceptyDo;
        return $this;
    }
    /**
     * Get dataWystawieniaReceptyOd value
     * @return string|null
     */
    public function getDataWystawieniaReceptyOd()
    {
        return $this->dataWystawieniaReceptyOd;
    }
    /**
     * Set dataWystawieniaReceptyOd value
     * @param string $dataWystawieniaReceptyOd
     * @return RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setDataWystawieniaReceptyOd($dataWystawieniaReceptyOd = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaReceptyOd) && !is_string($dataWystawieniaReceptyOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaReceptyOd, true), gettype($dataWystawieniaReceptyOd)), __LINE__);
        }
        $this->dataWystawieniaReceptyOd = $dataWystawieniaReceptyOd;
        return $this;
    }
    /**
     * Get nazwaLeku value
     * @return string|null
     */
    public function getNazwaLeku()
    {
        return $this->nazwaLeku;
    }
    /**
     * Set nazwaLeku value
     * @param string $nazwaLeku
     * @return RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setNazwaLeku($nazwaLeku = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaLeku) && !is_string($nazwaLeku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaLeku, true), gettype($nazwaLeku)), __LINE__);
        }
        $this->nazwaLeku = $nazwaLeku;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT|null
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
    /**
     * Get statusRecepty value
     * @return string|null
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
    /**
     * Get parametryStronicowania value
     * @return ParametryStronicowaniaMT|null
     */
    public function getParametryStronicowania()
    {
        return $this->parametryStronicowania;
    }
    /**
     * Set parametryStronicowania value
     * @param ParametryStronicowaniaMT $parametryStronicowania
     * @return RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setParametryStronicowania(ParametryStronicowaniaMT $parametryStronicowania = null)
    {
        $this->parametryStronicowania = $parametryStronicowania;
        return $this;
    }
    /**
     * Get czySytuacjaZagrozeniaZycia value
     * @return bool|null
     */
    public function getCzySytuacjaZagrozeniaZycia()
    {
        return $this->czySytuacjaZagrozeniaZycia;
    }
    /**
     * Set czySytuacjaZagrozeniaZycia value
     * @param bool $czySytuacjaZagrozeniaZycia
     * @return RozszerzoneKryteriaWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setCzySytuacjaZagrozeniaZycia($czySytuacjaZagrozeniaZycia = null)
    {
        // validation for constraint: boolean
        if (!is_null($czySytuacjaZagrozeniaZycia) && !is_bool($czySytuacjaZagrozeniaZycia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($czySytuacjaZagrozeniaZycia, true), gettype($czySytuacjaZagrozeniaZycia)), __LINE__);
        }
        $this->czySytuacjaZagrozeniaZycia = $czySytuacjaZagrozeniaZycia;
        return $this;
    }
}
