<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceptyMT StructType
 * @subpackage Structs
 */
class ReceptyMT extends AbstractStructBase
{
    /**
     * The recepta
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var ReceptaMT[]
     */
    public $recepta;
    /**
     * Constructor method for ReceptyMT
     * @uses ReceptyMT::setRecepta()
     * @param ReceptaMT[] $recepta
     */
    public function __construct(array $recepta = array())
    {
        $this
            ->setRecepta($recepta);
    }
    /**
     * Get recepta value
     * @return ReceptaMT[]
     */
    public function getRecepta()
    {
        return $this->recepta;
    }
    /**
     * This method is responsible for validating the values passed to the setRecepta method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecepta method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceptaForArrayConstraintsFromSetRecepta(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receptyMTReceptaItem) {
            // validation for constraint: itemType
            if (!$receptyMTReceptaItem instanceof ReceptaMT) {
                $invalidValues[] = is_object($receptyMTReceptaItem) ? get_class($receptyMTReceptaItem) : sprintf('%s(%s)', gettype($receptyMTReceptaItem), var_export($receptyMTReceptaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recepta property can only contain items of type ReceptaMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recepta value
     * @throws \InvalidArgumentException
     * @param ReceptaMT[] $recepta
     * @return ReceptyMT
     */
    public function setRecepta(array $recepta = array())
    {
        // validation for constraint: array
        if ('' !== ($receptaArrayErrorMessage = self::validateReceptaForArrayConstraintsFromSetRecepta($recepta))) {
            throw new \InvalidArgumentException($receptaArrayErrorMessage, __LINE__);
        }
        $this->recepta = $recepta;
        return $this;
    }
    /**
     * Add item to recepta value
     * @throws \InvalidArgumentException
     * @param ReceptaMT $item
     * @return ReceptyMT
     */
    public function addToRecepta(ReceptaMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ReceptaMT) {
            throw new \InvalidArgumentException(sprintf('The recepta property can only contain items of type ReceptaMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recepta[] = $item;
        return $this;
    }
}
