<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PakietReceptMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Pakiet recept albo identyfikator zadania utworzonego w P1 związanego z asynchroniczną obsługą zapisu lub weryfikacji pakietu recept.
 * @subpackage Structs
 */
class PakietReceptMT extends AbstractStructBase
{
    /**
     * The identyfikatorZadania
     * Meta information extracted from the WSDL
     * - choice: identyfikatorZadania | recepty
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var IdentyfikatorZadaniaMT
     */
    public $identyfikatorZadania;
    /**
     * The recepty
     * Meta information extracted from the WSDL
     * - choice: identyfikatorZadania | recepty
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ReceptyMT
     */
    public $recepty;
    /**
     * Constructor method for PakietReceptMT
     * @uses PakietReceptMT::setIdentyfikatorZadania()
     * @uses PakietReceptMT::setRecepty()
     * @param IdentyfikatorZadaniaMT $identyfikatorZadania
     * @param ReceptyMT $recepty
     */
    public function __construct(IdentyfikatorZadaniaMT $identyfikatorZadania = null, ReceptyMT $recepty = null)
    {
        $this
            ->setIdentyfikatorZadania($identyfikatorZadania)
            ->setRecepty($recepty);
    }
    /**
     * Get identyfikatorZadania value
     * @return IdentyfikatorZadaniaMT|null
     */
    public function getIdentyfikatorZadania()
    {
        return isset($this->identyfikatorZadania) ? $this->identyfikatorZadania : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIdentyfikatorZadania method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentyfikatorZadania method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIdentyfikatorZadaniaForChoiceConstraintsFromSetIdentyfikatorZadania($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'recepty',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property identyfikatorZadania can\'t be set as the property %s is already set. Only one property must be set among these properties: identyfikatorZadania, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set identyfikatorZadania value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param IdentyfikatorZadaniaMT $identyfikatorZadania
     * @return PakietReceptMT
     */
    public function setIdentyfikatorZadania(IdentyfikatorZadaniaMT $identyfikatorZadania = null)
    {
        // validation for constraint: choice(identyfikatorZadania, recepty)
        if ('' !== ($identyfikatorZadaniaChoiceErrorMessage = self::validateIdentyfikatorZadaniaForChoiceConstraintsFromSetIdentyfikatorZadania($identyfikatorZadania))) {
            throw new \InvalidArgumentException($identyfikatorZadaniaChoiceErrorMessage, __LINE__);
        }
        if (is_null($identyfikatorZadania) || (is_array($identyfikatorZadania) && empty($identyfikatorZadania))) {
            unset($this->identyfikatorZadania);
        } else {
            $this->identyfikatorZadania = $identyfikatorZadania;
        }
        return $this;
    }
    /**
     * Get recepty value
     * @return ReceptyMT|null
     */
    public function getRecepty()
    {
        return isset($this->recepty) ? $this->recepty : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRecepty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecepty method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReceptyForChoiceConstraintsFromSetRecepty($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'identyfikatorZadania',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property recepty can\'t be set as the property %s is already set. Only one property must be set among these properties: recepty, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set recepty value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param ReceptyMT $recepty
     * @return PakietReceptMT
     */
    public function setRecepty(ReceptyMT $recepty = null)
    {
        // validation for constraint: choice(identyfikatorZadania, recepty)
        if ('' !== ($receptyChoiceErrorMessage = self::validateReceptyForChoiceConstraintsFromSetRecepty($recepty))) {
            throw new \InvalidArgumentException($receptyChoiceErrorMessage, __LINE__);
        }
        if (is_null($recepty) || (is_array($recepty) && empty($recepty))) {
            unset($this->recepty);
        } else {
            $this->recepty = $recepty;
        }
        return $this;
    }
}
