<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Odczyt ServiceType
 * @subpackage Services
 */
class Odczyt extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20170510', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named odczytPakietuRecept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt pakietu recept na podstawie klucza pakietu ALBO kodu pakietu. (w przypadku przekazania obu parametrów operacja kończy się błędem). W przypadku wywołania operacji przez system usługodawcy wystawiającego recepty
     * obowiązkowym parametrem jest identyfikator pracownika medycznego, który wywołał operację.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytPakietuReceptRequest $odczytPakietuRecept
     * @return OdczytPakietuReceptResponse|bool
     */
    public function odczytPakietuRecept(OdczytPakietuReceptRequest $odczytPakietuRecept)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytPakietuRecept($odczytPakietuRecept));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named odczytRecepty
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt pojedynczej recepty elektronicznej na podstawie przekazanego klucza recepty. Wraz z receptą zwracany jest jej status oraz dokumenty realizacji i anulowania.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytReceptyRequest $odczytRecepty
     * @return OdczytReceptyResponse|bool
     */
    public function odczytRecepty(OdczytReceptyRequest $odczytRecepty)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytRecepty($odczytRecepty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named odczytPakietuReceptDoRealizacji
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt wszystkich recept elektronicznych pakietu recept na podstawie przekazanego klucza lub kodu pakietu. Razem z receptami zwracane są wyniki weryfikacji recept oraz dokumenty realizacji recept.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytPakietuReceptDoRealizacjiRequest $odczytPakietuReceptDoRealizacji
     * @return OdczytPakietuReceptDoRealizacjiResponse|bool
     */
    public function odczytPakietuReceptDoRealizacji(OdczytPakietuReceptDoRealizacjiRequest $odczytPakietuReceptDoRealizacji)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytPakietuReceptDoRealizacji($odczytPakietuReceptDoRealizacji));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named odczytReceptyDoRealizacji
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt pojedynczej recepty elektronicznej na podstawie przekazanego klucza recepty. Razem z receptą zwracane są wyniki weryfikacji recepty oraz dokumenty realizacji recepty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytReceptyDoRealizacjiRequest $odczytReceptyDoRealizacji
     * @return OdczytReceptyDoRealizacjiResponse|bool
     */
    public function odczytReceptyDoRealizacji(OdczytReceptyDoRealizacjiRequest $odczytReceptyDoRealizacji)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytReceptyDoRealizacji($odczytReceptyDoRealizacji));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named odczytReceptyDoKonsultacji
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt pojedynczego dokumentu recepty na podstawie przekazanego numeru recepty. Wraz z receptą zwracany jest jej status. Nie są zwracane dokumenty realizacji i recept. Zwracane dane dotyczące realizacji recepty to: data realizacji
     * recepty, ilość wydanego leku, nazwa leku realizacji. Usługodawca wywołujący usługę musi posiadać uprawnienia nadane przez usługobiorcę do dokumentu recepty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytReceptyDoKonsultacjiRequest $odczytReceptyDoKonsultacji
     * @return OdczytReceptyDoKonsultacjiResponse|bool
     */
    public function odczytReceptyDoKonsultacji(OdczytReceptyDoKonsultacjiRequest $odczytReceptyDoKonsultacji)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytReceptyDoKonsultacji($odczytReceptyDoKonsultacji));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * odczytDanychDostepowychPakietuRecept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt danych dostępowych do pakietu recept. Dane wejściowe to klucz jednej z recept w pakiecie oraz identyfikator pracownika medycznego, który wywołał operację. Wynikiem jest kod i klucz pakietu recept oraz klucze do
     * wszystkich recept w pakiecie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytDanychDostepowychPakietuReceptRequest $odczytDanychDostepowychPakietuRecept
     * @return OdczytDanychDostepowychPakietuReceptResponse|bool
     */
    public function odczytDanychDostepowychPakietuRecept(OdczytDanychDostepowychPakietuReceptRequest $odczytDanychDostepowychPakietuRecept)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytDanychDostepowychPakietuRecept($odczytDanychDostepowychPakietuRecept));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named odczytDokumentuAnulowaniaRecepty
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt pojedynczego dokumentu anulowania recepty na podstawie przekazanego identyfikatora dokumentu.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytDokumentuAnulowaniaReceptyRequest $odczytDokumentuAnulowaniaRecepty
     * @return OdczytDokumentuAnulowaniaReceptyResponse|bool
     */
    public function odczytDokumentuAnulowaniaRecepty(OdczytDokumentuAnulowaniaReceptyRequest $odczytDokumentuAnulowaniaRecepty)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytDokumentuAnulowaniaRecepty($odczytDokumentuAnulowaniaRecepty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named odczytDokumentuRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt pojedynczego dokumentu realizacji recepty na podstawie przekazanego identyfikatora dokumentu. Zwracany jest również status dokumentu realizacji recepty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytDokumentuRealizacjiReceptyRequest $odczytDokumentuRealizacjiRecept
     * @return OdczytDokumentuRealizacjiReceptyResponse|bool
     */
    public function odczytDokumentuRealizacjiRecepty(OdczytDokumentuRealizacjiReceptyRequest $odczytDokumentuRealizacjiRecept)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytDokumentuRealizacjiRecepty($odczytDokumentuRealizacjiRecept));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named odczytKluczyReceptUslugobiorcy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Odczyt kluczy recept usługobiorcy. Usługa przyjmuje w parametrze wejściowym dokument podpisany elektronicznym dowodem osobistym wraz z żądaną operacją i datą złożenia podpisu. Z wynikiem operacji zwracana jest lista kluczy
     * recept usługobiorcy, który podpisał dokument z żądania.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OdczytKluczyReceptUslugobiorcyRequest $odczytKluczyReceptUslugobiorcy
     * @return OdczytKluczyReceptUslugobiorcyResponse|bool
     */
    public function odczytKluczyReceptUslugobiorcy(OdczytKluczyReceptUslugobiorcyRequest $odczytKluczyReceptUslugobiorcy)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytKluczyReceptUslugobiorcy($odczytKluczyReceptUslugobiorcy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return OdczytDanychDostepowychPakietuReceptResponse|OdczytDokumentuAnulowaniaReceptyResponse|OdczytDokumentuRealizacjiReceptyResponse|OdczytKluczyReceptUslugobiorcyResponse|OdczytPakietuReceptDoRealizacjiResponse|OdczytPakietuReceptResponse|OdczytReceptyDoKonsultacjiResponse|OdczytReceptyDoRealizacjiResponse|OdczytReceptyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
