<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AtrybutMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Atrybut kontekstu. | Atrybut.
 * @subpackage Structs
 */
class AtrybutMT extends AbstractStructBase
{
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: Wartość atrybutu. | Wartość atrybutu kontekstu.
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minLength: 1
     * - minOccurs: 1
     * @var string[]
     */
    public $wartosc;
    /**
     * The nazwa
     * Meta information extracted from the WSDL
     * - documentation: Nazwa jako atrybutu elementu. | Nazwa jako atrybut elementu.
     * - use: optional
     * @var string
     */
    public $nazwa;
    /**
     * Constructor method for AtrybutMT
     * @uses AtrybutMT::setWartosc()
     * @uses AtrybutMT::setNazwa()
     * @param string[] $wartosc
     * @param string $nazwa
     */
    public function __construct(array $wartosc = array(), $nazwa = null)
    {
        $this
            ->setWartosc($wartosc)
            ->setNazwa($nazwa);
    }
    /**
     * Get wartosc value
     * @return string[]
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * This method is responsible for validating the values passed to the setWartosc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWartosc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWartoscForArrayConstraintsFromSetWartosc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $atrybutMTWartoscItem) {
            // validation for constraint: itemType
            if (!is_string($atrybutMTWartoscItem)) {
                $invalidValues[] = is_object($atrybutMTWartoscItem) ? get_class($atrybutMTWartoscItem) : sprintf('%s(%s)', gettype($atrybutMTWartoscItem), var_export($atrybutMTWartoscItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The wartosc property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setWartosc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWartosc method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWartoscForMinLengthConstraintFromSetWartosc($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $atrybutMTWartoscItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($atrybutMTWartoscItem) < 1) {
                $invalidValues[] = var_export($atrybutMTWartoscItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set wartosc value
     * @throws \InvalidArgumentException
     * @param string[] $wartosc
     * @return AtrybutMT
     */
    public function setWartosc(array $wartosc = array())
    {
        // validation for constraint: array
        if ('' !== ($wartoscArrayErrorMessage = self::validateWartoscForArrayConstraintsFromSetWartosc($wartosc))) {
            throw new \InvalidArgumentException($wartoscArrayErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($wartoscMinLengthErrorMessage = self::validateWartoscForMinLengthConstraintFromSetWartosc($wartosc))) {
            throw new \InvalidArgumentException($wartoscMinLengthErrorMessage, __LINE__);
        }
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Add item to wartosc value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return AtrybutMT
     */
    public function addToWartosc($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The wartosc property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->wartosc[] = $item;
        return $this;
    }
    /**
     * Get nazwa value
     * @return string|null
     */
    public function getNazwa()
    {
        return $this->nazwa;
    }
    /**
     * Set nazwa value
     * @param string $nazwa
     * @return AtrybutMT
     */
    public function setNazwa($nazwa = null)
    {
        // validation for constraint: string
        if (!is_null($nazwa) && !is_string($nazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwa, true), gettype($nazwa)), __LINE__);
        }
        $this->nazwa = $nazwa;
        return $this;
    }
}
