<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Odczyt ServiceType
 */
$odczyt = new Odczyt($options);
$odczyt->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for odczytPakietuRecept operation/method
 */
if ($odczyt->odczytPakietuRecept(new OdczytPakietuReceptRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytRecepty operation/method
 */
if ($odczyt->odczytRecepty(new OdczytReceptyRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytPakietuReceptDoRealizacji operation/method
 */
if ($odczyt->odczytPakietuReceptDoRealizacji(new OdczytPakietuReceptDoRealizacjiRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytReceptyDoRealizacji operation/method
 */
if ($odczyt->odczytReceptyDoRealizacji(new OdczytReceptyDoRealizacjiRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytReceptyDoKonsultacji operation/method
 */
if ($odczyt->odczytReceptyDoKonsultacji(new OdczytReceptyDoKonsultacjiRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytDanychDostepowychPakietuRecept operation/method
 */
if ($odczyt->odczytDanychDostepowychPakietuRecept(new OdczytDanychDostepowychPakietuReceptRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytDokumentuAnulowaniaRecepty operation/method
 */
if ($odczyt->odczytDokumentuAnulowaniaRecepty(new OdczytDokumentuAnulowaniaReceptyRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytDokumentuRealizacjiRecepty operation/method
 */
if ($odczyt->odczytDokumentuRealizacjiRecepty(new OdczytDokumentuRealizacjiReceptyRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytKluczyReceptUslugobiorcy operation/method
 */
if ($odczyt->odczytKluczyReceptUslugobiorcy(new OdczytKluczyReceptUslugobiorcyRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Samples for Przyjecie ServiceType
 */
$przyjecie = new Przyjecie($options);
$przyjecie->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for przyjecieDoRealizacjiReceptyNaLekRecepturowy operation/method
 */
if ($przyjecie->przyjecieDoRealizacjiReceptyNaLekRecepturowy(new PrzyjecieDoRealizacjiReceptyNaLekRecepturowyRequest()) !== false) {
    print_r($przyjecie->getResult());
} else {
    print_r($przyjecie->getLastError());
}
/**
 * Samples for Rezygnacja ServiceType
 */
$rezygnacja = new Rezygnacja($options);
$rezygnacja->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for rezygnacjaZRealizacjiReceptyNaLekRecepturowy operation/method
 */
if ($rezygnacja->rezygnacjaZRealizacjiReceptyNaLekRecepturowy(new RezygnacjaZRealizacjiReceptyNaLekRecepturowyRequest()) !== false) {
    print_r($rezygnacja->getResult());
} else {
    print_r($rezygnacja->getLastError());
}
/**
 * Samples for Weryfikacja ServiceType
 */
$weryfikacja = new Weryfikacja($options);
$weryfikacja->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for weryfikacjaPakietuRecept operation/method
 */
if ($weryfikacja->weryfikacjaPakietuRecept(new WeryfikacjaPakietuReceptRequest()) !== false) {
    print_r($weryfikacja->getResult());
} else {
    print_r($weryfikacja->getLastError());
}
/**
 * Samples for Zapis ServiceType
 */
$zapis = new Zapis($options);
$zapis->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for zapisRealizacjiReceptyFarmaceutycznej operation/method
 */
if ($zapis->zapisRealizacjiReceptyFarmaceutycznej(new ZapisRealizacjiReceptyFarmaceutycznejRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisRealizacjiRecepty operation/method
 */
if ($zapis->zapisRealizacjiRecepty(new ZapisRealizacjiReceptyRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisPakietuRecept operation/method
 */
if ($zapis->zapisPakietuRecept(new ZapisPakietuReceptRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisPakietuRealizacjiRecept operation/method
 */
if ($zapis->zapisPakietuRealizacjiRecept(new ZapisPakietuRealizacjiReceptRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisDokumentuAnulowaniaReceptyFarmaceutycznej operation/method
 */
if ($zapis->zapisDokumentuAnulowaniaReceptyFarmaceutycznej(new ZapisDokumentuAnulowaniaReceptyFarmaceutycznejRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisDokumentuAnulowaniaRecepty operation/method
 */
if ($zapis->zapisDokumentuAnulowaniaRecepty(new ZapisDokumentuAnulowaniaReceptyRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisKorektyDokumentuRealizacjiRecepty operation/method
 */
if ($zapis->zapisKorektyDokumentuRealizacjiRecepty(new ZapisKorektyDokumentuRealizacjiReceptyRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Samples for Wyszukanie ServiceType
 */
$wyszukanie = new Wyszukanie($options);
$wyszukanie->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for wyszukanieDokumentowRealizacjiRecept operation/method
 */
if ($wyszukanie->wyszukanieDokumentowRealizacjiRecept(new WyszukanieDokumentowRealizacjiReceptRequest()) !== false) {
    print_r($wyszukanie->getResult());
} else {
    print_r($wyszukanie->getLastError());
}
/**
 * Sample call for wyszukanieReceptWystawiajacego operation/method
 */
if ($wyszukanie->wyszukanieReceptWystawiajacego(new WyszukanieReceptWystawiajacegoRequest()) !== false) {
    print_r($wyszukanie->getResult());
} else {
    print_r($wyszukanie->getLastError());
}
/**
 * Sample call for wyszukanieReceptUslugobiorcyDoKonsultacji operation/method
 */
if ($wyszukanie->wyszukanieReceptUslugobiorcyDoKonsultacji(new WyszukanieReceptUslugobiorcyDoKonsultacjiRequest()) !== false) {
    print_r($wyszukanie->getResult());
} else {
    print_r($wyszukanie->getLastError());
}
/**
 * Sample call for wyszukanieRealizacjiReceptDoKonsultacji operation/method
 */
if ($wyszukanie->wyszukanieRealizacjiReceptDoKonsultacji(new WyszukanieRealizacjiReceptDoKonsultacjiRequest()) !== false) {
    print_r($wyszukanie->getResult());
} else {
    print_r($wyszukanie->getLastError());
}
/**
 * Sample call for wyszukanieReceptUslugobiorcy operation/method
 */
if ($wyszukanie->wyszukanieReceptUslugobiorcy(new WyszukanieReceptUslugobiorcyRequest()) !== false) {
    print_r($wyszukanie->getResult());
} else {
    print_r($wyszukanie->getLastError());
}
/**
 * Sample call for wyszukanieDokumentowAnulowaniaRecept operation/method
 */
if ($wyszukanie->wyszukanieDokumentowAnulowaniaRecept(new WyszukanieDokumentowAnulowaniaReceptRequest()) !== false) {
    print_r($wyszukanie->getResult());
} else {
    print_r($wyszukanie->getLastError());
}
/**
 * Samples for Zablokowanie ServiceType
 */
$zablokowanie = new Zablokowanie($options);
$zablokowanie->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for zablokowanieRecepty operation/method
 */
if ($zablokowanie->zablokowanieRecepty(new ZablokowanieReceptyRequest()) !== false) {
    print_r($zablokowanie->getResult());
} else {
    print_r($zablokowanie->getLastError());
}
/**
 * Samples for Odblokowanie ServiceType
 */
$odblokowanie = new Odblokowanie($options);
$odblokowanie->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for odblokowanieRecepty operation/method
 */
if ($odblokowanie->odblokowanieRecepty(new OdblokowanieReceptyRequest()) !== false) {
    print_r($odblokowanie->getResult());
} else {
    print_r($odblokowanie->getLastError());
}
/**
 * Samples for Rozszerzone ServiceType
 */
$rozszerzone = new Rozszerzone($options);
$rozszerzone->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for rozszerzoneWyszukiwanieReceptUslugobiorcy operation/method
 */
if ($rozszerzone->rozszerzoneWyszukiwanieReceptUslugobiorcy(new RozszerzoneWyszukiwanieReceptUslugobiorcyRequest()) !== false) {
    print_r($rozszerzone->getResult());
} else {
    print_r($rozszerzone->getLastError());
}
