<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zablokowanie ServiceType
 * @subpackage Services
 */
class Zablokowanie extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20170510', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named zablokowanieRecepty
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Zablokowanie recepty. Parametry wejściowe to klucz recepty oraz przyczyna zablokowania recepty (enum). W wyniku zwracane jest potwierdzenie wykonania operacji.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZablokowanieReceptyRequest $zablokowanieRecepty
     * @return ZablokowanieReceptyResponse|bool
     */
    public function zablokowanieRecepty(ZablokowanieReceptyRequest $zablokowanieRecepty)
    {
        try {
            $this->setResult($this->getSoapClient()->zablokowanieRecepty($zablokowanieRecepty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ZablokowanieReceptyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
