<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Wyszukanie ServiceType
 * @subpackage Services
 */
class Wyszukanie extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20170510', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * wyszukanieDokumentowRealizacjiRecept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Wyszukanie dokumentów realizacji recept na podstawie podanych w zapytaniu kryteriów wyszukiwania. Operacja przeznaczona dla usługodawców realizujących recepty. Wynikiem operacji jest lista informacji o dokumentach realizacji
     * recept, które spełniają kryteria wyszukiwania oraz zostały wystawione przez usługodawcę wywołującego usługę wyszukania. Zapytanie o dokumenty realizacji recept wymaga wskazania kontekstu usługodawcy. W przypadku, gdy liczba wyników
     * zapytania przekracza próg określony w parametrach P1 operacja kończy się błędem bez zwracania wyników.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param WyszukanieDokumentowRealizacjiReceptRequest $wyszukanieDokumentowRealizacjiRecept
     * @return WyszukanieDokumentowRealizacjiReceptResponse|bool
     */
    public function wyszukanieDokumentowRealizacjiRecept(WyszukanieDokumentowRealizacjiReceptRequest $wyszukanieDokumentowRealizacjiRecept)
    {
        try {
            $this->setResult($this->getSoapClient()->wyszukanieDokumentowRealizacjiRecept($wyszukanieDokumentowRealizacjiRecept));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named wyszukanieReceptWystawiajacego
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Wyszukanie recept na podstawie podanych w zapytaniu kryteriów wyszukiwania. Operacja przeznaczona dla usługodawców wystawiających recepty. Wynikiem operacji jest lista informacji o receptach, które spełniają kryteria
     * wyszukiwania. Zapytanie o recepty wymaga wskazania kontekstu usługodawcy. W przypadku gdy liczba wyników zapytania przekracza próg określony w parametrach P1 operacja kończy się błędem bez zwracania wyników.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param WyszukanieReceptWystawiajacegoRequest $wyszukanieReceptWystawiajacego
     * @return WyszukanieReceptWystawiajacegoResponse|bool
     */
    public function wyszukanieReceptWystawiajacego(WyszukanieReceptWystawiajacegoRequest $wyszukanieReceptWystawiajacego)
    {
        try {
            $this->setResult($this->getSoapClient()->wyszukanieReceptWystawiajacego($wyszukanieReceptWystawiajacego));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * wyszukanieReceptUslugobiorcyDoKonsultacji
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Wyszukanie recept na podstawie podanych w zapytaniu kryteriów wyszukiwania. Operacja przeznaczona dla systemów aptecznych. Wynikiem operacji jest lista informacji o receptach, które spełniają kryteria wyszukiwania. Usługodawca
     * wywołujący usługę musi posiadać uprawnienia nadane przez usługobiorcę do dokumentu recepty. Zapytanie o recepty wymaga wskazania kontekstu usługodawcy. W przypadku gdy liczba wyników zapytania przekracza próg określony w parametrach P1
     * operacja kończy się błędem bez zwracania wyników.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param WyszukanieReceptUslugobiorcyDoKonsultacjiRequest $wyszukanieReceptUslugobiorcyDoKonsultacji
     * @return WyszukanieReceptUslugobiorcyDoKonsultacjiResponse|bool
     */
    public function wyszukanieReceptUslugobiorcyDoKonsultacji(WyszukanieReceptUslugobiorcyDoKonsultacjiRequest $wyszukanieReceptUslugobiorcyDoKonsultacji)
    {
        try {
            $this->setResult($this->getSoapClient()->wyszukanieReceptUslugobiorcyDoKonsultacji($wyszukanieReceptUslugobiorcyDoKonsultacji));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * wyszukanieRealizacjiReceptDoKonsultacji
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Wyszukanie dokumentów realizacji recept na podstawie podanych w zapytaniu kryteriów wyszukiwania. Operacja przeznaczona dla usługodawców realizujących recepty. Wynikiem operacji jest lista informacji o dokumentach realizacji
     * recept, które spełniają kryteria wyszukiwania. Usługodawca wywołujący usługę musi posiadać uprawnienia nadane przez usługobiorcę do dokumentów realizacji. Zapytanie o dokumenty realizacji recept wymaga wskazania kontekstu usługodawcy. W
     * przypadku, gdy liczba wyników zapytania przekracza próg określony w parametrach P1 operacja kończy się błędem bez zwracania wyników.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param WyszukanieRealizacjiReceptDoKonsultacjiRequest $wyszukanieRealizacjiReceptDoKonsultacji
     * @return WyszukanieRealizacjiReceptDoKonsultacjiResponse|bool
     */
    public function wyszukanieRealizacjiReceptDoKonsultacji(WyszukanieRealizacjiReceptDoKonsultacjiRequest $wyszukanieRealizacjiReceptDoKonsultacji)
    {
        try {
            $this->setResult($this->getSoapClient()->wyszukanieRealizacjiReceptDoKonsultacji($wyszukanieRealizacjiReceptDoKonsultacji));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named wyszukanieReceptUslugobiorcy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Wyszukanie recept na podstawie podanych w zapytaniu kryteriów wyszukiwania. Operacja przeznaczona dla usługodawców wystawiających recepty. Wynikiem operacji jest lista informacji o receptach, które spełniają kryteria
     * wyszukiwania. Zapytanie o recepty wymaga wskazania kontekstu usługodawcy. W przypadku gdy liczba wyników zapytania przekracza próg określony w parametrach P1 operacja kończy się błędem bez zwracania wyników.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param WyszukanieReceptUslugobiorcyRequest $wyszukanieReceptUslugobiorcy
     * @return WyszukanieReceptUslugobiorcyResponse|bool
     */
    public function wyszukanieReceptUslugobiorcy(WyszukanieReceptUslugobiorcyRequest $wyszukanieReceptUslugobiorcy)
    {
        try {
            $this->setResult($this->getSoapClient()->wyszukanieReceptUslugobiorcy($wyszukanieReceptUslugobiorcy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * wyszukanieDokumentowAnulowaniaRecept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Wyszukanie dokumentów anulowania recept. Parametry wejściowe to kryteria wyszukiwania dokumentów anulowania. W wyniku zwracana jest lista informacji o dokumentach anulowania spełniających kryteria wyszukiwania.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param WyszukanieDokumentowAnulowaniaReceptRequest $wyszukanieDokumentowAnulowaniaRecept
     * @return WyszukanieDokumentowAnulowaniaReceptResponse|bool
     */
    public function wyszukanieDokumentowAnulowaniaRecept(WyszukanieDokumentowAnulowaniaReceptRequest $wyszukanieDokumentowAnulowaniaRecept)
    {
        try {
            $this->setResult($this->getSoapClient()->wyszukanieDokumentowAnulowaniaRecept($wyszukanieDokumentowAnulowaniaRecept));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return WyszukanieDokumentowAnulowaniaReceptResponse|WyszukanieDokumentowRealizacjiReceptResponse|WyszukanieRealizacjiReceptDoKonsultacjiResponse|WyszukanieReceptUslugobiorcyDoKonsultacjiResponse|WyszukanieReceptUslugobiorcyResponse|WyszukanieReceptWystawiajacegoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
