<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikWyszukiwaniaReceptMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Pojedynczy wynik wyszukiwania recepty.
 * @subpackage Structs
 */
class WynikWyszukiwaniaReceptMT extends AbstractStructBase
{
    /**
     * The kluczRecepty
     * Meta information extracted from the WSDL
     * - documentation: Klucz recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kluczRecepty;
    /**
     * The kluczPakietu
     * Meta information extracted from the WSDL
     * - documentation: Klucz pakietu recept zawierającego recepty spełniające kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kluczPakietu;
    /**
     * The dataWystawieniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia recepty (przez datę wystawienia recepty rozumie się moment zapisu recepty w Systemie P1).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataWystawieniaRecepty;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusRecepty;
    /**
     * The przyczynaZablokowaniaRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $przyczynaZablokowaniaRecepty;
    /**
     * Constructor method for WynikWyszukiwaniaReceptMT
     * @uses WynikWyszukiwaniaReceptMT::setKluczRecepty()
     * @uses WynikWyszukiwaniaReceptMT::setKluczPakietu()
     * @uses WynikWyszukiwaniaReceptMT::setDataWystawieniaRecepty()
     * @uses WynikWyszukiwaniaReceptMT::setNumerRecepty()
     * @uses WynikWyszukiwaniaReceptMT::setStatusRecepty()
     * @uses WynikWyszukiwaniaReceptMT::setPrzyczynaZablokowaniaRecepty()
     * @param string $kluczRecepty
     * @param string $kluczPakietu
     * @param string $dataWystawieniaRecepty
     * @param NumerReceptyOIDMT $numerRecepty
     * @param string $statusRecepty
     * @param string $przyczynaZablokowaniaRecepty
     */
    public function __construct($kluczRecepty = null, $kluczPakietu = null, $dataWystawieniaRecepty = null, NumerReceptyOIDMT $numerRecepty = null, $statusRecepty = null, $przyczynaZablokowaniaRecepty = null)
    {
        $this
            ->setKluczRecepty($kluczRecepty)
            ->setKluczPakietu($kluczPakietu)
            ->setDataWystawieniaRecepty($dataWystawieniaRecepty)
            ->setNumerRecepty($numerRecepty)
            ->setStatusRecepty($statusRecepty)
            ->setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty);
    }
    /**
     * Get kluczRecepty value
     * @return string
     */
    public function getKluczRecepty()
    {
        return $this->kluczRecepty;
    }
    /**
     * Set kluczRecepty value
     * @param string $kluczRecepty
     * @return WynikWyszukiwaniaReceptMT
     */
    public function setKluczRecepty($kluczRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($kluczRecepty) && !is_string($kluczRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczRecepty, true), gettype($kluczRecepty)), __LINE__);
        }
        $this->kluczRecepty = $kluczRecepty;
        return $this;
    }
    /**
     * Get kluczPakietu value
     * @return string
     */
    public function getKluczPakietu()
    {
        return $this->kluczPakietu;
    }
    /**
     * Set kluczPakietu value
     * @param string $kluczPakietu
     * @return WynikWyszukiwaniaReceptMT
     */
    public function setKluczPakietu($kluczPakietu = null)
    {
        // validation for constraint: string
        if (!is_null($kluczPakietu) && !is_string($kluczPakietu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczPakietu, true), gettype($kluczPakietu)), __LINE__);
        }
        $this->kluczPakietu = $kluczPakietu;
        return $this;
    }
    /**
     * Get dataWystawieniaRecepty value
     * @return string
     */
    public function getDataWystawieniaRecepty()
    {
        return $this->dataWystawieniaRecepty;
    }
    /**
     * Set dataWystawieniaRecepty value
     * @param string $dataWystawieniaRecepty
     * @return WynikWyszukiwaniaReceptMT
     */
    public function setDataWystawieniaRecepty($dataWystawieniaRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaRecepty) && !is_string($dataWystawieniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaRecepty, true), gettype($dataWystawieniaRecepty)), __LINE__);
        }
        $this->dataWystawieniaRecepty = $dataWystawieniaRecepty;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return WynikWyszukiwaniaReceptMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
    /**
     * Get statusRecepty value
     * @return string
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return WynikWyszukiwaniaReceptMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
    /**
     * Get przyczynaZablokowaniaRecepty value
     * @return string|null
     */
    public function getPrzyczynaZablokowaniaRecepty()
    {
        return $this->przyczynaZablokowaniaRecepty;
    }
    /**
     * Set przyczynaZablokowaniaRecepty value
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid()
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $przyczynaZablokowaniaRecepty
     * @return WynikWyszukiwaniaReceptMT
     */
    public function setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty = null)
    {
        // validation for constraint: enumeration
        if (!PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid($przyczynaZablokowaniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrzyczynaZablokowaniaReceptyEnumMT', is_array($przyczynaZablokowaniaRecepty) ? implode(', ', $przyczynaZablokowaniaRecepty) : var_export($przyczynaZablokowaniaRecepty, true), implode(', ', PrzyczynaZablokowaniaReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->przyczynaZablokowaniaRecepty = $przyczynaZablokowaniaRecepty;
        return $this;
    }
}
