<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikWeryfikacjiZbioruRegulMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Wynik weryfikacji zbioru reguł uruchamianych w ramach weryfikacji dokumentu. Poza zbiorczym wynikiem weryfikacji jest również lista wyników z poszczególnych reguł.
 * @subpackage Structs
 */
class WynikWeryfikacjiZbioruRegulMT extends AbstractStructBase
{
    /**
     * The wynikWeryfikacji
     * Meta information extracted from the WSDL
     * - documentation: Zbiorczy wynik weryfikacji dokumentu. Jeśli co najmniej jedna reguła zbioru reguł zakończyła sie z wynikiem błędnym to zbiorczy wynik wreyfikacji również wskazuje błąd. Analogicznie obsługiwane są ostrzeżenia. Jeśli
     * żadna reguła nie zwróciła błędu lub ostrzeżenia wówczas zbiorczy wynik weryfikacji dla dokumentu jest pozytywny.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $wynikWeryfikacji;
    /**
     * The identyfikatorZbioruRegul
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator zbioru reguł, które są uruchamiane w ramach weryfikacji dokumentu. Identyfikator pozwala na wskazanie dokładnej wersji konfiguracji, która została zastosowana. Identyfikator to ciąg x.y[.z] gdzie x-główny numer
     * wersji; y-pomocniczy numer wersji; z - fix/build/patch (opcjonalny). pierwsza wersja 0.1, w x, y i z nie stosujemy 0 wiodących (tzn. nie tworzymy wersji 01.034 tylko 1.34).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identyfikatorZbioruRegul;
    /**
     * The wynikWeryfikacjiReguly
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var WynikWeryfikacjiRegulyMT[]
     */
    public $wynikWeryfikacjiReguly;
    /**
     * Constructor method for WynikWeryfikacjiZbioruRegulMT
     * @uses WynikWeryfikacjiZbioruRegulMT::setWynikWeryfikacji()
     * @uses WynikWeryfikacjiZbioruRegulMT::setIdentyfikatorZbioruRegul()
     * @uses WynikWeryfikacjiZbioruRegulMT::setWynikWeryfikacjiReguly()
     * @param string $wynikWeryfikacji
     * @param string $identyfikatorZbioruRegul
     * @param WynikWeryfikacjiRegulyMT[] $wynikWeryfikacjiReguly
     */
    public function __construct($wynikWeryfikacji = null, $identyfikatorZbioruRegul = null, array $wynikWeryfikacjiReguly = array())
    {
        $this
            ->setWynikWeryfikacji($wynikWeryfikacji)
            ->setIdentyfikatorZbioruRegul($identyfikatorZbioruRegul)
            ->setWynikWeryfikacjiReguly($wynikWeryfikacjiReguly);
    }
    /**
     * Get wynikWeryfikacji value
     * @return string
     */
    public function getWynikWeryfikacji()
    {
        return $this->wynikWeryfikacji;
    }
    /**
     * Set wynikWeryfikacji value
     * @uses KodWynikuWeryfikacjiEnumMT::valueIsValid()
     * @uses KodWynikuWeryfikacjiEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wynikWeryfikacji
     * @return WynikWeryfikacjiZbioruRegulMT
     */
    public function setWynikWeryfikacji($wynikWeryfikacji = null)
    {
        // validation for constraint: enumeration
        if (!KodWynikuWeryfikacjiEnumMT::valueIsValid($wynikWeryfikacji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class KodWynikuWeryfikacjiEnumMT', is_array($wynikWeryfikacji) ? implode(', ', $wynikWeryfikacji) : var_export($wynikWeryfikacji, true), implode(', ', KodWynikuWeryfikacjiEnumMT::getValidValues())), __LINE__);
        }
        $this->wynikWeryfikacji = $wynikWeryfikacji;
        return $this;
    }
    /**
     * Get identyfikatorZbioruRegul value
     * @return string
     */
    public function getIdentyfikatorZbioruRegul()
    {
        return $this->identyfikatorZbioruRegul;
    }
    /**
     * Set identyfikatorZbioruRegul value
     * @param string $identyfikatorZbioruRegul
     * @return WynikWeryfikacjiZbioruRegulMT
     */
    public function setIdentyfikatorZbioruRegul($identyfikatorZbioruRegul = null)
    {
        // validation for constraint: string
        if (!is_null($identyfikatorZbioruRegul) && !is_string($identyfikatorZbioruRegul)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identyfikatorZbioruRegul, true), gettype($identyfikatorZbioruRegul)), __LINE__);
        }
        $this->identyfikatorZbioruRegul = $identyfikatorZbioruRegul;
        return $this;
    }
    /**
     * Get wynikWeryfikacjiReguly value
     * @return WynikWeryfikacjiRegulyMT[]|null
     */
    public function getWynikWeryfikacjiReguly()
    {
        return $this->wynikWeryfikacjiReguly;
    }
    /**
     * This method is responsible for validating the values passed to the setWynikWeryfikacjiReguly method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWynikWeryfikacjiReguly method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWynikWeryfikacjiRegulyForArrayConstraintsFromSetWynikWeryfikacjiReguly(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $wynikWeryfikacjiZbioruRegulMTWynikWeryfikacjiRegulyItem) {
            // validation for constraint: itemType
            if (!$wynikWeryfikacjiZbioruRegulMTWynikWeryfikacjiRegulyItem instanceof WynikWeryfikacjiRegulyMT) {
                $invalidValues[] = is_object($wynikWeryfikacjiZbioruRegulMTWynikWeryfikacjiRegulyItem) ? get_class($wynikWeryfikacjiZbioruRegulMTWynikWeryfikacjiRegulyItem) : sprintf('%s(%s)', gettype($wynikWeryfikacjiZbioruRegulMTWynikWeryfikacjiRegulyItem), var_export($wynikWeryfikacjiZbioruRegulMTWynikWeryfikacjiRegulyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The wynikWeryfikacjiReguly property can only contain items of type WynikWeryfikacjiRegulyMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set wynikWeryfikacjiReguly value
     * @throws \InvalidArgumentException
     * @param WynikWeryfikacjiRegulyMT[] $wynikWeryfikacjiReguly
     * @return WynikWeryfikacjiZbioruRegulMT
     */
    public function setWynikWeryfikacjiReguly(array $wynikWeryfikacjiReguly = array())
    {
        // validation for constraint: array
        if ('' !== ($wynikWeryfikacjiRegulyArrayErrorMessage = self::validateWynikWeryfikacjiRegulyForArrayConstraintsFromSetWynikWeryfikacjiReguly($wynikWeryfikacjiReguly))) {
            throw new \InvalidArgumentException($wynikWeryfikacjiRegulyArrayErrorMessage, __LINE__);
        }
        $this->wynikWeryfikacjiReguly = $wynikWeryfikacjiReguly;
        return $this;
    }
    /**
     * Add item to wynikWeryfikacjiReguly value
     * @throws \InvalidArgumentException
     * @param WynikWeryfikacjiRegulyMT $item
     * @return WynikWeryfikacjiZbioruRegulMT
     */
    public function addToWynikWeryfikacjiReguly(WynikWeryfikacjiRegulyMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof WynikWeryfikacjiRegulyMT) {
            throw new \InvalidArgumentException(sprintf('The wynikWeryfikacjiReguly property can only contain items of type WynikWeryfikacjiRegulyMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->wynikWeryfikacjiReguly[] = $item;
        return $this;
    }
}
