<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikWeryfikacjiRegulyMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Wynik weryfikacji zbioru reguł uruchamianych w ramach weryfikacji dokumentu. Poza zbiorczym wynikiem weryfikacji jest również lista wyników z poszczególnych reguł.
 * @subpackage Structs
 */
class WynikWeryfikacjiRegulyMT extends AbstractStructBase
{
    /**
     * The kodRegulyWeryfikacji
     * Meta information extracted from the WSDL
     * - documentation: Kod reguły
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kodRegulyWeryfikacji;
    /**
     * The wynikWeryfikacji
     * Meta information extracted from the WSDL
     * - documentation: Wynik weryfikacji reguły na dokumencie
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $wynikWeryfikacji;
    /**
     * The opisProblemu
     * Meta information extracted from the WSDL
     * - documentation: Opis znalezionego problemu tj. błędu lub ostrzeżenia.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $opisProblemu;
    /**
     * The miejsceWystapieniaBledu
     * Meta information extracted from the WSDL
     * - documentation: Wskazanie na miejsce w dokumencie, gdzie znaleziono problem tj. błąd lub ostrzeżenie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $miejsceWystapieniaBledu;
    /**
     * Constructor method for WynikWeryfikacjiRegulyMT
     * @uses WynikWeryfikacjiRegulyMT::setKodRegulyWeryfikacji()
     * @uses WynikWeryfikacjiRegulyMT::setWynikWeryfikacji()
     * @uses WynikWeryfikacjiRegulyMT::setOpisProblemu()
     * @uses WynikWeryfikacjiRegulyMT::setMiejsceWystapieniaBledu()
     * @param string $kodRegulyWeryfikacji
     * @param string $wynikWeryfikacji
     * @param string $opisProblemu
     * @param string $miejsceWystapieniaBledu
     */
    public function __construct($kodRegulyWeryfikacji = null, $wynikWeryfikacji = null, $opisProblemu = null, $miejsceWystapieniaBledu = null)
    {
        $this
            ->setKodRegulyWeryfikacji($kodRegulyWeryfikacji)
            ->setWynikWeryfikacji($wynikWeryfikacji)
            ->setOpisProblemu($opisProblemu)
            ->setMiejsceWystapieniaBledu($miejsceWystapieniaBledu);
    }
    /**
     * Get kodRegulyWeryfikacji value
     * @return string
     */
    public function getKodRegulyWeryfikacji()
    {
        return $this->kodRegulyWeryfikacji;
    }
    /**
     * Set kodRegulyWeryfikacji value
     * @param string $kodRegulyWeryfikacji
     * @return WynikWeryfikacjiRegulyMT
     */
    public function setKodRegulyWeryfikacji($kodRegulyWeryfikacji = null)
    {
        // validation for constraint: string
        if (!is_null($kodRegulyWeryfikacji) && !is_string($kodRegulyWeryfikacji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodRegulyWeryfikacji, true), gettype($kodRegulyWeryfikacji)), __LINE__);
        }
        $this->kodRegulyWeryfikacji = $kodRegulyWeryfikacji;
        return $this;
    }
    /**
     * Get wynikWeryfikacji value
     * @return string
     */
    public function getWynikWeryfikacji()
    {
        return $this->wynikWeryfikacji;
    }
    /**
     * Set wynikWeryfikacji value
     * @uses KodWynikuWeryfikacjiEnumMT::valueIsValid()
     * @uses KodWynikuWeryfikacjiEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wynikWeryfikacji
     * @return WynikWeryfikacjiRegulyMT
     */
    public function setWynikWeryfikacji($wynikWeryfikacji = null)
    {
        // validation for constraint: enumeration
        if (!KodWynikuWeryfikacjiEnumMT::valueIsValid($wynikWeryfikacji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class KodWynikuWeryfikacjiEnumMT', is_array($wynikWeryfikacji) ? implode(', ', $wynikWeryfikacji) : var_export($wynikWeryfikacji, true), implode(', ', KodWynikuWeryfikacjiEnumMT::getValidValues())), __LINE__);
        }
        $this->wynikWeryfikacji = $wynikWeryfikacji;
        return $this;
    }
    /**
     * Get opisProblemu value
     * @return string|null
     */
    public function getOpisProblemu()
    {
        return $this->opisProblemu;
    }
    /**
     * Set opisProblemu value
     * @param string $opisProblemu
     * @return WynikWeryfikacjiRegulyMT
     */
    public function setOpisProblemu($opisProblemu = null)
    {
        // validation for constraint: string
        if (!is_null($opisProblemu) && !is_string($opisProblemu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opisProblemu, true), gettype($opisProblemu)), __LINE__);
        }
        $this->opisProblemu = $opisProblemu;
        return $this;
    }
    /**
     * Get miejsceWystapieniaBledu value
     * @return string|null
     */
    public function getMiejsceWystapieniaBledu()
    {
        return $this->miejsceWystapieniaBledu;
    }
    /**
     * Set miejsceWystapieniaBledu value
     * @param string $miejsceWystapieniaBledu
     * @return WynikWeryfikacjiRegulyMT
     */
    public function setMiejsceWystapieniaBledu($miejsceWystapieniaBledu = null)
    {
        // validation for constraint: string
        if (!is_null($miejsceWystapieniaBledu) && !is_string($miejsceWystapieniaBledu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($miejsceWystapieniaBledu, true), gettype($miejsceWystapieniaBledu)), __LINE__);
        }
        $this->miejsceWystapieniaBledu = $miejsceWystapieniaBledu;
        return $this;
    }
}
