<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Pojedynczy wynik rozszerzonego wyszukiwania recept usługobiorcy.
 * @subpackage Structs
 */
class WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT extends AbstractStructBase
{
    /**
     * The dataWystawieniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia recepty (przez datę wystawienia recepty rozumie się moment zapisu recepty w Systemie P1).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataWystawieniaRecepty;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusRecepty;
    /**
     * The dataPierwszegoWydaniaLeku
     * Meta information extracted from the WSDL
     * - documentation: Data wydania pierwszego opakowania leku.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataPierwszegoWydaniaLeku;
    /**
     * The dataRealizacjiOd
     * Meta information extracted from the WSDL
     * - documentation: Wskazana w dokumencie recepty data od której można rozpocząć realizację recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataRealizacjiOd;
    /**
     * The dataRealizacjiDo
     * Meta information extracted from the WSDL
     * - documentation: Wskazana w dokumencie recepty data do której można realizować receptę (dotyczy recept 365).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataRealizacjiDo;
    /**
     * The identyfikatorOpakowaniaLeku
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator opakowania leku zgodny z rejestrem leków systemu P1 (EAN/GTIN).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identyfikatorOpakowaniaLeku;
    /**
     * The iloscLeku
     * Meta information extracted from the WSDL
     * - documentation: Ilość przepisanego leku (ilość opakowań).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $iloscLeku;
    /**
     * The kluczRecepty
     * Meta information extracted from the WSDL
     * - documentation: Klucz recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kluczRecepty;
    /**
     * The nazwaPrzepisanegoLeku
     * Meta information extracted from the WSDL
     * - documentation: Nazwa leku z dokumentu recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nazwaPrzepisanegoLeku;
    /**
     * The przyczynaZablokowaniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Przyczyna zablokowania recepty spełniającej kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $przyczynaZablokowaniaRecepty;
    /**
     * The rodzajLeku
     * Meta information extracted from the WSDL
     * - documentation: Rodzaj leku wskazany w dokumencie recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rodzajLeku;
    /**
     * The statusMozliwosciRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Flaga określająca możliwość realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $statusMozliwosciRealizacjiRecepty;
    /**
     * The wielkoscOpakowania
     * Meta information extracted from the WSDL
     * - documentation: Wielkość opakowania przepisanego leku wraz z jednostką opakowania.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wielkoscOpakowania;
    /**
     * The poziomOdplatnosciRecepty
     * Meta information extracted from the WSDL
     * - documentation: Poziom odpłatności wskazany w dokumencie recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $poziomOdplatnosciRecepty;
    /**
     * The daneDokumentuRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Dane dokumentu realizacji recepty powiązanego z dokumentem recepty.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DaneDokumentuRealizacjiReceptyMT[]
     */
    public $daneDokumentuRealizacjiRecepty;
    /**
     * The uprawnieniaDodatkowe
     * Meta information extracted from the WSDL
     * - documentation: Uprawnienia dodatkowe wskazane w dokumencie.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var UprawnieniaDodatkoweMT[]
     */
    public $uprawnieniaDodatkowe;
    /**
     * Constructor method for WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setDataWystawieniaRecepty()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setNumerRecepty()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setStatusRecepty()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setDataPierwszegoWydaniaLeku()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setDataRealizacjiOd()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setDataRealizacjiDo()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setIdentyfikatorOpakowaniaLeku()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setIloscLeku()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setKluczRecepty()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setNazwaPrzepisanegoLeku()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setPrzyczynaZablokowaniaRecepty()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setRodzajLeku()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setStatusMozliwosciRealizacjiRecepty()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setWielkoscOpakowania()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setPoziomOdplatnosciRecepty()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setDaneDokumentuRealizacjiRecepty()
     * @uses WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT::setUprawnieniaDodatkowe()
     * @param string $dataWystawieniaRecepty
     * @param NumerReceptyOIDMT $numerRecepty
     * @param string $statusRecepty
     * @param string $dataPierwszegoWydaniaLeku
     * @param string $dataRealizacjiOd
     * @param string $dataRealizacjiDo
     * @param string $identyfikatorOpakowaniaLeku
     * @param float $iloscLeku
     * @param string $kluczRecepty
     * @param string $nazwaPrzepisanegoLeku
     * @param string $przyczynaZablokowaniaRecepty
     * @param string $rodzajLeku
     * @param bool $statusMozliwosciRealizacjiRecepty
     * @param string $wielkoscOpakowania
     * @param string $poziomOdplatnosciRecepty
     * @param DaneDokumentuRealizacjiReceptyMT[] $daneDokumentuRealizacjiRecepty
     * @param UprawnieniaDodatkoweMT[] $uprawnieniaDodatkowe
     */
    public function __construct($dataWystawieniaRecepty = null, NumerReceptyOIDMT $numerRecepty = null, $statusRecepty = null, $dataPierwszegoWydaniaLeku = null, $dataRealizacjiOd = null, $dataRealizacjiDo = null, $identyfikatorOpakowaniaLeku = null, $iloscLeku = null, $kluczRecepty = null, $nazwaPrzepisanegoLeku = null, $przyczynaZablokowaniaRecepty = null, $rodzajLeku = null, $statusMozliwosciRealizacjiRecepty = null, $wielkoscOpakowania = null, $poziomOdplatnosciRecepty = null, array $daneDokumentuRealizacjiRecepty = array(), array $uprawnieniaDodatkowe = array())
    {
        $this
            ->setDataWystawieniaRecepty($dataWystawieniaRecepty)
            ->setNumerRecepty($numerRecepty)
            ->setStatusRecepty($statusRecepty)
            ->setDataPierwszegoWydaniaLeku($dataPierwszegoWydaniaLeku)
            ->setDataRealizacjiOd($dataRealizacjiOd)
            ->setDataRealizacjiDo($dataRealizacjiDo)
            ->setIdentyfikatorOpakowaniaLeku($identyfikatorOpakowaniaLeku)
            ->setIloscLeku($iloscLeku)
            ->setKluczRecepty($kluczRecepty)
            ->setNazwaPrzepisanegoLeku($nazwaPrzepisanegoLeku)
            ->setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty)
            ->setRodzajLeku($rodzajLeku)
            ->setStatusMozliwosciRealizacjiRecepty($statusMozliwosciRealizacjiRecepty)
            ->setWielkoscOpakowania($wielkoscOpakowania)
            ->setPoziomOdplatnosciRecepty($poziomOdplatnosciRecepty)
            ->setDaneDokumentuRealizacjiRecepty($daneDokumentuRealizacjiRecepty)
            ->setUprawnieniaDodatkowe($uprawnieniaDodatkowe);
    }
    /**
     * Get dataWystawieniaRecepty value
     * @return string
     */
    public function getDataWystawieniaRecepty()
    {
        return $this->dataWystawieniaRecepty;
    }
    /**
     * Set dataWystawieniaRecepty value
     * @param string $dataWystawieniaRecepty
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setDataWystawieniaRecepty($dataWystawieniaRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaRecepty) && !is_string($dataWystawieniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaRecepty, true), gettype($dataWystawieniaRecepty)), __LINE__);
        }
        $this->dataWystawieniaRecepty = $dataWystawieniaRecepty;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
    /**
     * Get statusRecepty value
     * @return string
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
    /**
     * Get dataPierwszegoWydaniaLeku value
     * @return string|null
     */
    public function getDataPierwszegoWydaniaLeku()
    {
        return $this->dataPierwszegoWydaniaLeku;
    }
    /**
     * Set dataPierwszegoWydaniaLeku value
     * @param string $dataPierwszegoWydaniaLeku
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setDataPierwszegoWydaniaLeku($dataPierwszegoWydaniaLeku = null)
    {
        // validation for constraint: string
        if (!is_null($dataPierwszegoWydaniaLeku) && !is_string($dataPierwszegoWydaniaLeku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataPierwszegoWydaniaLeku, true), gettype($dataPierwszegoWydaniaLeku)), __LINE__);
        }
        $this->dataPierwszegoWydaniaLeku = $dataPierwszegoWydaniaLeku;
        return $this;
    }
    /**
     * Get dataRealizacjiOd value
     * @return string|null
     */
    public function getDataRealizacjiOd()
    {
        return $this->dataRealizacjiOd;
    }
    /**
     * Set dataRealizacjiOd value
     * @param string $dataRealizacjiOd
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setDataRealizacjiOd($dataRealizacjiOd = null)
    {
        // validation for constraint: string
        if (!is_null($dataRealizacjiOd) && !is_string($dataRealizacjiOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRealizacjiOd, true), gettype($dataRealizacjiOd)), __LINE__);
        }
        $this->dataRealizacjiOd = $dataRealizacjiOd;
        return $this;
    }
    /**
     * Get dataRealizacjiDo value
     * @return string|null
     */
    public function getDataRealizacjiDo()
    {
        return $this->dataRealizacjiDo;
    }
    /**
     * Set dataRealizacjiDo value
     * @param string $dataRealizacjiDo
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setDataRealizacjiDo($dataRealizacjiDo = null)
    {
        // validation for constraint: string
        if (!is_null($dataRealizacjiDo) && !is_string($dataRealizacjiDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRealizacjiDo, true), gettype($dataRealizacjiDo)), __LINE__);
        }
        $this->dataRealizacjiDo = $dataRealizacjiDo;
        return $this;
    }
    /**
     * Get identyfikatorOpakowaniaLeku value
     * @return string|null
     */
    public function getIdentyfikatorOpakowaniaLeku()
    {
        return $this->identyfikatorOpakowaniaLeku;
    }
    /**
     * Set identyfikatorOpakowaniaLeku value
     * @param string $identyfikatorOpakowaniaLeku
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setIdentyfikatorOpakowaniaLeku($identyfikatorOpakowaniaLeku = null)
    {
        // validation for constraint: string
        if (!is_null($identyfikatorOpakowaniaLeku) && !is_string($identyfikatorOpakowaniaLeku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identyfikatorOpakowaniaLeku, true), gettype($identyfikatorOpakowaniaLeku)), __LINE__);
        }
        $this->identyfikatorOpakowaniaLeku = $identyfikatorOpakowaniaLeku;
        return $this;
    }
    /**
     * Get iloscLeku value
     * @return float|null
     */
    public function getIloscLeku()
    {
        return $this->iloscLeku;
    }
    /**
     * Set iloscLeku value
     * @param float $iloscLeku
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setIloscLeku($iloscLeku = null)
    {
        // validation for constraint: float
        if (!is_null($iloscLeku) && !(is_float($iloscLeku) || is_numeric($iloscLeku))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iloscLeku, true), gettype($iloscLeku)), __LINE__);
        }
        $this->iloscLeku = $iloscLeku;
        return $this;
    }
    /**
     * Get kluczRecepty value
     * @return string|null
     */
    public function getKluczRecepty()
    {
        return $this->kluczRecepty;
    }
    /**
     * Set kluczRecepty value
     * @param string $kluczRecepty
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setKluczRecepty($kluczRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($kluczRecepty) && !is_string($kluczRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczRecepty, true), gettype($kluczRecepty)), __LINE__);
        }
        $this->kluczRecepty = $kluczRecepty;
        return $this;
    }
    /**
     * Get nazwaPrzepisanegoLeku value
     * @return string|null
     */
    public function getNazwaPrzepisanegoLeku()
    {
        return $this->nazwaPrzepisanegoLeku;
    }
    /**
     * Set nazwaPrzepisanegoLeku value
     * @param string $nazwaPrzepisanegoLeku
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setNazwaPrzepisanegoLeku($nazwaPrzepisanegoLeku = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaPrzepisanegoLeku) && !is_string($nazwaPrzepisanegoLeku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaPrzepisanegoLeku, true), gettype($nazwaPrzepisanegoLeku)), __LINE__);
        }
        $this->nazwaPrzepisanegoLeku = $nazwaPrzepisanegoLeku;
        return $this;
    }
    /**
     * Get przyczynaZablokowaniaRecepty value
     * @return string|null
     */
    public function getPrzyczynaZablokowaniaRecepty()
    {
        return $this->przyczynaZablokowaniaRecepty;
    }
    /**
     * Set przyczynaZablokowaniaRecepty value
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid()
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $przyczynaZablokowaniaRecepty
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty = null)
    {
        // validation for constraint: enumeration
        if (!PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid($przyczynaZablokowaniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrzyczynaZablokowaniaReceptyEnumMT', is_array($przyczynaZablokowaniaRecepty) ? implode(', ', $przyczynaZablokowaniaRecepty) : var_export($przyczynaZablokowaniaRecepty, true), implode(', ', PrzyczynaZablokowaniaReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->przyczynaZablokowaniaRecepty = $przyczynaZablokowaniaRecepty;
        return $this;
    }
    /**
     * Get rodzajLeku value
     * @return string|null
     */
    public function getRodzajLeku()
    {
        return $this->rodzajLeku;
    }
    /**
     * Set rodzajLeku value
     * @uses RodzajLekuEnumMT::valueIsValid()
     * @uses RodzajLekuEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rodzajLeku
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setRodzajLeku($rodzajLeku = null)
    {
        // validation for constraint: enumeration
        if (!RodzajLekuEnumMT::valueIsValid($rodzajLeku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class RodzajLekuEnumMT', is_array($rodzajLeku) ? implode(', ', $rodzajLeku) : var_export($rodzajLeku, true), implode(', ', RodzajLekuEnumMT::getValidValues())), __LINE__);
        }
        $this->rodzajLeku = $rodzajLeku;
        return $this;
    }
    /**
     * Get statusMozliwosciRealizacjiRecepty value
     * @return bool|null
     */
    public function getStatusMozliwosciRealizacjiRecepty()
    {
        return $this->statusMozliwosciRealizacjiRecepty;
    }
    /**
     * Set statusMozliwosciRealizacjiRecepty value
     * @param bool $statusMozliwosciRealizacjiRecepty
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setStatusMozliwosciRealizacjiRecepty($statusMozliwosciRealizacjiRecepty = null)
    {
        // validation for constraint: boolean
        if (!is_null($statusMozliwosciRealizacjiRecepty) && !is_bool($statusMozliwosciRealizacjiRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($statusMozliwosciRealizacjiRecepty, true), gettype($statusMozliwosciRealizacjiRecepty)), __LINE__);
        }
        $this->statusMozliwosciRealizacjiRecepty = $statusMozliwosciRealizacjiRecepty;
        return $this;
    }
    /**
     * Get wielkoscOpakowania value
     * @return string|null
     */
    public function getWielkoscOpakowania()
    {
        return $this->wielkoscOpakowania;
    }
    /**
     * Set wielkoscOpakowania value
     * @param string $wielkoscOpakowania
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setWielkoscOpakowania($wielkoscOpakowania = null)
    {
        // validation for constraint: string
        if (!is_null($wielkoscOpakowania) && !is_string($wielkoscOpakowania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wielkoscOpakowania, true), gettype($wielkoscOpakowania)), __LINE__);
        }
        $this->wielkoscOpakowania = $wielkoscOpakowania;
        return $this;
    }
    /**
     * Get poziomOdplatnosciRecepty value
     * @return string|null
     */
    public function getPoziomOdplatnosciRecepty()
    {
        return $this->poziomOdplatnosciRecepty;
    }
    /**
     * Set poziomOdplatnosciRecepty value
     * @param string $poziomOdplatnosciRecepty
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setPoziomOdplatnosciRecepty($poziomOdplatnosciRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($poziomOdplatnosciRecepty) && !is_string($poziomOdplatnosciRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poziomOdplatnosciRecepty, true), gettype($poziomOdplatnosciRecepty)), __LINE__);
        }
        $this->poziomOdplatnosciRecepty = $poziomOdplatnosciRecepty;
        return $this;
    }
    /**
     * Get daneDokumentuRealizacjiRecepty value
     * @return DaneDokumentuRealizacjiReceptyMT[]|null
     */
    public function getDaneDokumentuRealizacjiRecepty()
    {
        return $this->daneDokumentuRealizacjiRecepty;
    }
    /**
     * This method is responsible for validating the values passed to the setDaneDokumentuRealizacjiRecepty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDaneDokumentuRealizacjiRecepty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDaneDokumentuRealizacjiReceptyForArrayConstraintsFromSetDaneDokumentuRealizacjiRecepty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTDaneDokumentuRealizacjiReceptyItem) {
            // validation for constraint: itemType
            if (!$wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTDaneDokumentuRealizacjiReceptyItem instanceof DaneDokumentuRealizacjiReceptyMT) {
                $invalidValues[] = is_object($wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTDaneDokumentuRealizacjiReceptyItem) ? get_class($wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTDaneDokumentuRealizacjiReceptyItem) : sprintf('%s(%s)', gettype($wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTDaneDokumentuRealizacjiReceptyItem), var_export($wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTDaneDokumentuRealizacjiReceptyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The daneDokumentuRealizacjiRecepty property can only contain items of type DaneDokumentuRealizacjiReceptyMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set daneDokumentuRealizacjiRecepty value
     * @throws \InvalidArgumentException
     * @param DaneDokumentuRealizacjiReceptyMT[] $daneDokumentuRealizacjiRecepty
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setDaneDokumentuRealizacjiRecepty(array $daneDokumentuRealizacjiRecepty = array())
    {
        // validation for constraint: array
        if ('' !== ($daneDokumentuRealizacjiReceptyArrayErrorMessage = self::validateDaneDokumentuRealizacjiReceptyForArrayConstraintsFromSetDaneDokumentuRealizacjiRecepty($daneDokumentuRealizacjiRecepty))) {
            throw new \InvalidArgumentException($daneDokumentuRealizacjiReceptyArrayErrorMessage, __LINE__);
        }
        $this->daneDokumentuRealizacjiRecepty = $daneDokumentuRealizacjiRecepty;
        return $this;
    }
    /**
     * Add item to daneDokumentuRealizacjiRecepty value
     * @throws \InvalidArgumentException
     * @param DaneDokumentuRealizacjiReceptyMT $item
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function addToDaneDokumentuRealizacjiRecepty(DaneDokumentuRealizacjiReceptyMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DaneDokumentuRealizacjiReceptyMT) {
            throw new \InvalidArgumentException(sprintf('The daneDokumentuRealizacjiRecepty property can only contain items of type DaneDokumentuRealizacjiReceptyMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->daneDokumentuRealizacjiRecepty[] = $item;
        return $this;
    }
    /**
     * Get uprawnieniaDodatkowe value
     * @return UprawnieniaDodatkoweMT[]|null
     */
    public function getUprawnieniaDodatkowe()
    {
        return $this->uprawnieniaDodatkowe;
    }
    /**
     * This method is responsible for validating the values passed to the setUprawnieniaDodatkowe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUprawnieniaDodatkowe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUprawnieniaDodatkoweForArrayConstraintsFromSetUprawnieniaDodatkowe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTUprawnieniaDodatkoweItem) {
            // validation for constraint: itemType
            if (!$wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTUprawnieniaDodatkoweItem instanceof UprawnieniaDodatkoweMT) {
                $invalidValues[] = is_object($wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTUprawnieniaDodatkoweItem) ? get_class($wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTUprawnieniaDodatkoweItem) : sprintf('%s(%s)', gettype($wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTUprawnieniaDodatkoweItem), var_export($wynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMTUprawnieniaDodatkoweItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The uprawnieniaDodatkowe property can only contain items of type UprawnieniaDodatkoweMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set uprawnieniaDodatkowe value
     * @throws \InvalidArgumentException
     * @param UprawnieniaDodatkoweMT[] $uprawnieniaDodatkowe
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function setUprawnieniaDodatkowe(array $uprawnieniaDodatkowe = array())
    {
        // validation for constraint: array
        if ('' !== ($uprawnieniaDodatkoweArrayErrorMessage = self::validateUprawnieniaDodatkoweForArrayConstraintsFromSetUprawnieniaDodatkowe($uprawnieniaDodatkowe))) {
            throw new \InvalidArgumentException($uprawnieniaDodatkoweArrayErrorMessage, __LINE__);
        }
        $this->uprawnieniaDodatkowe = $uprawnieniaDodatkowe;
        return $this;
    }
    /**
     * Add item to uprawnieniaDodatkowe value
     * @throws \InvalidArgumentException
     * @param UprawnieniaDodatkoweMT $item
     * @return WynikRozszerzonegoWyszukiwaniaReceptUslugobiorcyMT
     */
    public function addToUprawnieniaDodatkowe(UprawnieniaDodatkoweMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof UprawnieniaDodatkoweMT) {
            throw new \InvalidArgumentException(sprintf('The uprawnieniaDodatkowe property can only contain items of type UprawnieniaDodatkoweMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->uprawnieniaDodatkowe[] = $item;
        return $this;
    }
}
