<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rozszerzone ServiceType
 * @subpackage Services
 */
class Rozszerzone extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20170510', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * rozszerzoneWyszukiwanieReceptUslugobiorcy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Wyszukiwanie recept na podstawie podanych w zapytaniu kryteriów wyszukiwania. Operacja przeznaczona dla usługodawców wystawiających recepty. Wynikiem operacji jest rozszerzona lista informacji o receptach i realizacjach (o ile
     * realizacje istnieją), które spełniają kryteria wyszukiwania. Zapytanie o recepty wymaga wskazania kontekstu usługodawcy.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RozszerzoneWyszukiwanieReceptUslugobiorcyRequest $rozszerzoneWyszukiwanieReceptUslugobiorcy
     * @return RozszerzoneWyszukiwanieReceptUslugobiorcyResponse|bool
     */
    public function rozszerzoneWyszukiwanieReceptUslugobiorcy(RozszerzoneWyszukiwanieReceptUslugobiorcyRequest $rozszerzoneWyszukiwanieReceptUslugobiorcy)
    {
        try {
            $this->setResult($this->getSoapClient()->rozszerzoneWyszukiwanieReceptUslugobiorcy($rozszerzoneWyszukiwanieReceptUslugobiorcy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return RozszerzoneWyszukiwanieReceptUslugobiorcyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
