<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rezygnacja ServiceType
 * @subpackage Services
 */
class Rezygnacja extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20170510', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * rezygnacjaZRealizacjiReceptyNaLekRecepturowy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Rezygnacja z realizacji recepty na lek recepturowy. Parametrami wejściowymi są klucz recepty lub klucz pakietu lub kod dostepu do pakietu lub numer recepty papierowej. Operacja odblokowuje w systemie daną receptę co wiąze się
     * ze zmianą jej statusu z Zablokowna na Wystawiona.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RezygnacjaZRealizacjiReceptyNaLekRecepturowyRequest $rezygnacjaZRealizacjiReceptyNaLekRecepturowy
     * @return RezygnacjaZRealizacjiReceptyNaLekRecepturowyResponse|bool
     */
    public function rezygnacjaZRealizacjiReceptyNaLekRecepturowy(RezygnacjaZRealizacjiReceptyNaLekRecepturowyRequest $rezygnacjaZRealizacjiReceptyNaLekRecepturowy)
    {
        try {
            $this->setResult($this->getSoapClient()->rezygnacjaZRealizacjiReceptyNaLekRecepturowy($rezygnacjaZRealizacjiReceptyNaLekRecepturowy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return RezygnacjaZRealizacjiReceptyNaLekRecepturowyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
