<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceptaMT StructType
 * @subpackage Structs
 */
class ReceptaMT extends AbstractStructBase
{
    /**
     * The identyfikatorDokumentuWPakiecie
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator recepty w pakiecie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $identyfikatorDokumentuWPakiecie;
    /**
     * The tresc
     * Meta information extracted from the WSDL
     * - documentation: Dokument recepty zgodny z HL7 CDA.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tresc;
    /**
     * The receptaDaneDodatkoweMT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ReceptaDaneDodatkoweMT
     */
    public $receptaDaneDodatkoweMT;
    /**
     * Constructor method for ReceptaMT
     * @uses ReceptaMT::setIdentyfikatorDokumentuWPakiecie()
     * @uses ReceptaMT::setTresc()
     * @uses ReceptaMT::setReceptaDaneDodatkoweMT()
     * @param int $identyfikatorDokumentuWPakiecie
     * @param string $tresc
     * @param ReceptaDaneDodatkoweMT $receptaDaneDodatkoweMT
     */
    public function __construct($identyfikatorDokumentuWPakiecie = null, $tresc = null, ReceptaDaneDodatkoweMT $receptaDaneDodatkoweMT = null)
    {
        $this
            ->setIdentyfikatorDokumentuWPakiecie($identyfikatorDokumentuWPakiecie)
            ->setTresc($tresc)
            ->setReceptaDaneDodatkoweMT($receptaDaneDodatkoweMT);
    }
    /**
     * Get identyfikatorDokumentuWPakiecie value
     * @return int
     */
    public function getIdentyfikatorDokumentuWPakiecie()
    {
        return $this->identyfikatorDokumentuWPakiecie;
    }
    /**
     * Set identyfikatorDokumentuWPakiecie value
     * @param int $identyfikatorDokumentuWPakiecie
     * @return ReceptaMT
     */
    public function setIdentyfikatorDokumentuWPakiecie($identyfikatorDokumentuWPakiecie = null)
    {
        // validation for constraint: int
        if (!is_null($identyfikatorDokumentuWPakiecie) && !(is_int($identyfikatorDokumentuWPakiecie) || ctype_digit($identyfikatorDokumentuWPakiecie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identyfikatorDokumentuWPakiecie, true), gettype($identyfikatorDokumentuWPakiecie)), __LINE__);
        }
        $this->identyfikatorDokumentuWPakiecie = $identyfikatorDokumentuWPakiecie;
        return $this;
    }
    /**
     * Get tresc value
     * @return string
     */
    public function getTresc()
    {
        return $this->tresc;
    }
    /**
     * Set tresc value
     * @param string $tresc
     * @return ReceptaMT
     */
    public function setTresc($tresc = null)
    {
        // validation for constraint: string
        if (!is_null($tresc) && !is_string($tresc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tresc, true), gettype($tresc)), __LINE__);
        }
        $this->tresc = $tresc;
        return $this;
    }
    /**
     * Get receptaDaneDodatkoweMT value
     * @return ReceptaDaneDodatkoweMT|null
     */
    public function getReceptaDaneDodatkoweMT()
    {
        return $this->receptaDaneDodatkoweMT;
    }
    /**
     * Set receptaDaneDodatkoweMT value
     * @param ReceptaDaneDodatkoweMT $receptaDaneDodatkoweMT
     * @return ReceptaMT
     */
    public function setReceptaDaneDodatkoweMT(ReceptaDaneDodatkoweMT $receptaDaneDodatkoweMT = null)
    {
        $this->receptaDaneDodatkoweMT = $receptaDaneDodatkoweMT;
        return $this;
    }
}
