<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceptaIRealizacjaMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Dokument recepty, wyniki weryfikacji recepty, istniejące dokumenty realizacji recepty, oraz ew. dokument anulowania.
 * @subpackage Structs
 */
class ReceptaIRealizacjaMT extends AbstractStructBase
{
    /**
     * The kluczRecepty
     * Meta information extracted from the WSDL
     * - documentation: Klucz zwracanej recepty do realizacji.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kluczRecepty;
    /**
     * The dokumentRecepty
     * Meta information extracted from the WSDL
     * - documentation: Treść dokumentu recepty farmaceutycznej (XML, HL7 CDA), zakodowana za pomocą base64.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var DokumentReceptyMT
     */
    public $dokumentRecepty;
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status dokumentu recepty w systemie P1.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusRecepty;
    /**
     * The wynikWeryfikacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Wynik weryfikacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var WynikWeryfikacjiZbioruRegulMT
     */
    public $wynikWeryfikacjiRecepty;
    /**
     * The przyczynaZablokowaniaRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $przyczynaZablokowaniaRecepty;
    /**
     * The dokumentRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Treść dokumentu realizacji recepty (XML, HL7 CDA), zakodowana za pomocą base64.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DokumentRealizacjiReceptyMT[]
     */
    public $dokumentRealizacjiRecepty;
    /**
     * The dokumentAnulowaniaRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DokumentAnulowaniaReceptyMT
     */
    public $dokumentAnulowaniaRecepty;
    /**
     * Constructor method for ReceptaIRealizacjaMT
     * @uses ReceptaIRealizacjaMT::setKluczRecepty()
     * @uses ReceptaIRealizacjaMT::setDokumentRecepty()
     * @uses ReceptaIRealizacjaMT::setStatusRecepty()
     * @uses ReceptaIRealizacjaMT::setWynikWeryfikacjiRecepty()
     * @uses ReceptaIRealizacjaMT::setPrzyczynaZablokowaniaRecepty()
     * @uses ReceptaIRealizacjaMT::setDokumentRealizacjiRecepty()
     * @uses ReceptaIRealizacjaMT::setDokumentAnulowaniaRecepty()
     * @param string $kluczRecepty
     * @param DokumentReceptyMT $dokumentRecepty
     * @param string $statusRecepty
     * @param WynikWeryfikacjiZbioruRegulMT $wynikWeryfikacjiRecepty
     * @param string $przyczynaZablokowaniaRecepty
     * @param DokumentRealizacjiReceptyMT[] $dokumentRealizacjiRecepty
     * @param DokumentAnulowaniaReceptyMT $dokumentAnulowaniaRecepty
     */
    public function __construct($kluczRecepty = null, DokumentReceptyMT $dokumentRecepty = null, $statusRecepty = null, WynikWeryfikacjiZbioruRegulMT $wynikWeryfikacjiRecepty = null, $przyczynaZablokowaniaRecepty = null, array $dokumentRealizacjiRecepty = array(), DokumentAnulowaniaReceptyMT $dokumentAnulowaniaRecepty = null)
    {
        $this
            ->setKluczRecepty($kluczRecepty)
            ->setDokumentRecepty($dokumentRecepty)
            ->setStatusRecepty($statusRecepty)
            ->setWynikWeryfikacjiRecepty($wynikWeryfikacjiRecepty)
            ->setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty)
            ->setDokumentRealizacjiRecepty($dokumentRealizacjiRecepty)
            ->setDokumentAnulowaniaRecepty($dokumentAnulowaniaRecepty);
    }
    /**
     * Get kluczRecepty value
     * @return string
     */
    public function getKluczRecepty()
    {
        return $this->kluczRecepty;
    }
    /**
     * Set kluczRecepty value
     * @param string $kluczRecepty
     * @return ReceptaIRealizacjaMT
     */
    public function setKluczRecepty($kluczRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($kluczRecepty) && !is_string($kluczRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczRecepty, true), gettype($kluczRecepty)), __LINE__);
        }
        $this->kluczRecepty = $kluczRecepty;
        return $this;
    }
    /**
     * Get dokumentRecepty value
     * @return DokumentReceptyMT
     */
    public function getDokumentRecepty()
    {
        return $this->dokumentRecepty;
    }
    /**
     * Set dokumentRecepty value
     * @param DokumentReceptyMT $dokumentRecepty
     * @return ReceptaIRealizacjaMT
     */
    public function setDokumentRecepty(DokumentReceptyMT $dokumentRecepty = null)
    {
        $this->dokumentRecepty = $dokumentRecepty;
        return $this;
    }
    /**
     * Get statusRecepty value
     * @return string
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return ReceptaIRealizacjaMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
    /**
     * Get wynikWeryfikacjiRecepty value
     * @return WynikWeryfikacjiZbioruRegulMT
     */
    public function getWynikWeryfikacjiRecepty()
    {
        return $this->wynikWeryfikacjiRecepty;
    }
    /**
     * Set wynikWeryfikacjiRecepty value
     * @param WynikWeryfikacjiZbioruRegulMT $wynikWeryfikacjiRecepty
     * @return ReceptaIRealizacjaMT
     */
    public function setWynikWeryfikacjiRecepty(WynikWeryfikacjiZbioruRegulMT $wynikWeryfikacjiRecepty = null)
    {
        $this->wynikWeryfikacjiRecepty = $wynikWeryfikacjiRecepty;
        return $this;
    }
    /**
     * Get przyczynaZablokowaniaRecepty value
     * @return string|null
     */
    public function getPrzyczynaZablokowaniaRecepty()
    {
        return $this->przyczynaZablokowaniaRecepty;
    }
    /**
     * Set przyczynaZablokowaniaRecepty value
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid()
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $przyczynaZablokowaniaRecepty
     * @return ReceptaIRealizacjaMT
     */
    public function setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty = null)
    {
        // validation for constraint: enumeration
        if (!PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid($przyczynaZablokowaniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrzyczynaZablokowaniaReceptyEnumMT', is_array($przyczynaZablokowaniaRecepty) ? implode(', ', $przyczynaZablokowaniaRecepty) : var_export($przyczynaZablokowaniaRecepty, true), implode(', ', PrzyczynaZablokowaniaReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->przyczynaZablokowaniaRecepty = $przyczynaZablokowaniaRecepty;
        return $this;
    }
    /**
     * Get dokumentRealizacjiRecepty value
     * @return DokumentRealizacjiReceptyMT[]|null
     */
    public function getDokumentRealizacjiRecepty()
    {
        return $this->dokumentRealizacjiRecepty;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentRealizacjiRecepty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentRealizacjiRecepty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentRealizacjiReceptyForArrayConstraintsFromSetDokumentRealizacjiRecepty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receptaIRealizacjaMTDokumentRealizacjiReceptyItem) {
            // validation for constraint: itemType
            if (!$receptaIRealizacjaMTDokumentRealizacjiReceptyItem instanceof DokumentRealizacjiReceptyMT) {
                $invalidValues[] = is_object($receptaIRealizacjaMTDokumentRealizacjiReceptyItem) ? get_class($receptaIRealizacjaMTDokumentRealizacjiReceptyItem) : sprintf('%s(%s)', gettype($receptaIRealizacjaMTDokumentRealizacjiReceptyItem), var_export($receptaIRealizacjaMTDokumentRealizacjiReceptyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dokumentRealizacjiRecepty property can only contain items of type DokumentRealizacjiReceptyMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dokumentRealizacjiRecepty value
     * @throws \InvalidArgumentException
     * @param DokumentRealizacjiReceptyMT[] $dokumentRealizacjiRecepty
     * @return ReceptaIRealizacjaMT
     */
    public function setDokumentRealizacjiRecepty(array $dokumentRealizacjiRecepty = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentRealizacjiReceptyArrayErrorMessage = self::validateDokumentRealizacjiReceptyForArrayConstraintsFromSetDokumentRealizacjiRecepty($dokumentRealizacjiRecepty))) {
            throw new \InvalidArgumentException($dokumentRealizacjiReceptyArrayErrorMessage, __LINE__);
        }
        $this->dokumentRealizacjiRecepty = $dokumentRealizacjiRecepty;
        return $this;
    }
    /**
     * Add item to dokumentRealizacjiRecepty value
     * @throws \InvalidArgumentException
     * @param DokumentRealizacjiReceptyMT $item
     * @return ReceptaIRealizacjaMT
     */
    public function addToDokumentRealizacjiRecepty(DokumentRealizacjiReceptyMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DokumentRealizacjiReceptyMT) {
            throw new \InvalidArgumentException(sprintf('The dokumentRealizacjiRecepty property can only contain items of type DokumentRealizacjiReceptyMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dokumentRealizacjiRecepty[] = $item;
        return $this;
    }
    /**
     * Get dokumentAnulowaniaRecepty value
     * @return DokumentAnulowaniaReceptyMT|null
     */
    public function getDokumentAnulowaniaRecepty()
    {
        return $this->dokumentAnulowaniaRecepty;
    }
    /**
     * Set dokumentAnulowaniaRecepty value
     * @param DokumentAnulowaniaReceptyMT $dokumentAnulowaniaRecepty
     * @return ReceptaIRealizacjaMT
     */
    public function setDokumentAnulowaniaRecepty(DokumentAnulowaniaReceptyMT $dokumentAnulowaniaRecepty = null)
    {
        $this->dokumentAnulowaniaRecepty = $dokumentAnulowaniaRecepty;
        return $this;
    }
}
