<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RealizacjaReceptyMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Informacje o dokumencie realizacji recepty i jego statusie.
 * @subpackage Structs
 */
class RealizacjaReceptyMT extends AbstractStructBase
{
    /**
     * The dokumentRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Treść dokumentu realizacji recepty (XML, HL7 CDA), zakodowana za pomocą base64.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dokumentRealizacjiRecepty;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: Status dokumentu realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * Constructor method for RealizacjaReceptyMT
     * @uses RealizacjaReceptyMT::setDokumentRealizacjiRecepty()
     * @uses RealizacjaReceptyMT::setStatus()
     * @param string $dokumentRealizacjiRecepty
     * @param string $status
     */
    public function __construct($dokumentRealizacjiRecepty = null, $status = null)
    {
        $this
            ->setDokumentRealizacjiRecepty($dokumentRealizacjiRecepty)
            ->setStatus($status);
    }
    /**
     * Get dokumentRealizacjiRecepty value
     * @return string
     */
    public function getDokumentRealizacjiRecepty()
    {
        return $this->dokumentRealizacjiRecepty;
    }
    /**
     * Set dokumentRealizacjiRecepty value
     * @param string $dokumentRealizacjiRecepty
     * @return RealizacjaReceptyMT
     */
    public function setDokumentRealizacjiRecepty($dokumentRealizacjiRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($dokumentRealizacjiRecepty) && !is_string($dokumentRealizacjiRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dokumentRealizacjiRecepty, true), gettype($dokumentRealizacjiRecepty)), __LINE__);
        }
        $this->dokumentRealizacjiRecepty = $dokumentRealizacjiRecepty;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses StatusDokumentuRealizacjiReceptyEnumMT::valueIsValid()
     * @uses StatusDokumentuRealizacjiReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return RealizacjaReceptyMT
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!StatusDokumentuRealizacjiReceptyEnumMT::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusDokumentuRealizacjiReceptyEnumMT', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', StatusDokumentuRealizacjiReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
