<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DaneDokumentuRealizacjiReceptyMT StructType
 * @subpackage Structs
 */
class DaneDokumentuRealizacjiReceptyMT extends AbstractStructBase
{
    /**
     * The dataWystawieniaDokumentuRealizacji
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataWystawieniaDokumentuRealizacji;
    /**
     * The identyfikatorOpakowaniaLeku
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator opakowania leku zgodny z rejestrem leków systemu P1 (EAN/GTIN).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identyfikatorOpakowaniaLeku;
    /**
     * The iloscLeku
     * Meta information extracted from the WSDL
     * - documentation: Ilość wydanego leku (ilość opakowań).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $iloscLeku;
    /**
     * The nazwaWydanegoLeku
     * Meta information extracted from the WSDL
     * - documentation: Nazwa leku z dokumentu realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nazwaWydanegoLeku;
    /**
     * The wielkoscOpakowania
     * Meta information extracted from the WSDL
     * - documentation: Wielkość opakowania wydanego leku wraz z jednostką opakowania.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wielkoscOpakowania;
    /**
     * The poziomOdplatnosciRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Poziom odpłatności wskazany w dokumencie realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $poziomOdplatnosciRealizacjiRecepty;
    /**
     * The uprawnieniaDodatkowe
     * Meta information extracted from the WSDL
     * - documentation: Uprawnienia dodatkowe wskazane w dokumencie.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var UprawnieniaDodatkoweMT[]
     */
    public $uprawnieniaDodatkowe;
    /**
     * Constructor method for DaneDokumentuRealizacjiReceptyMT
     * @uses DaneDokumentuRealizacjiReceptyMT::setDataWystawieniaDokumentuRealizacji()
     * @uses DaneDokumentuRealizacjiReceptyMT::setIdentyfikatorOpakowaniaLeku()
     * @uses DaneDokumentuRealizacjiReceptyMT::setIloscLeku()
     * @uses DaneDokumentuRealizacjiReceptyMT::setNazwaWydanegoLeku()
     * @uses DaneDokumentuRealizacjiReceptyMT::setWielkoscOpakowania()
     * @uses DaneDokumentuRealizacjiReceptyMT::setPoziomOdplatnosciRealizacjiRecepty()
     * @uses DaneDokumentuRealizacjiReceptyMT::setUprawnieniaDodatkowe()
     * @param string $dataWystawieniaDokumentuRealizacji
     * @param string $identyfikatorOpakowaniaLeku
     * @param float $iloscLeku
     * @param string $nazwaWydanegoLeku
     * @param string $wielkoscOpakowania
     * @param string $poziomOdplatnosciRealizacjiRecepty
     * @param UprawnieniaDodatkoweMT[] $uprawnieniaDodatkowe
     */
    public function __construct($dataWystawieniaDokumentuRealizacji = null, $identyfikatorOpakowaniaLeku = null, $iloscLeku = null, $nazwaWydanegoLeku = null, $wielkoscOpakowania = null, $poziomOdplatnosciRealizacjiRecepty = null, array $uprawnieniaDodatkowe = array())
    {
        $this
            ->setDataWystawieniaDokumentuRealizacji($dataWystawieniaDokumentuRealizacji)
            ->setIdentyfikatorOpakowaniaLeku($identyfikatorOpakowaniaLeku)
            ->setIloscLeku($iloscLeku)
            ->setNazwaWydanegoLeku($nazwaWydanegoLeku)
            ->setWielkoscOpakowania($wielkoscOpakowania)
            ->setPoziomOdplatnosciRealizacjiRecepty($poziomOdplatnosciRealizacjiRecepty)
            ->setUprawnieniaDodatkowe($uprawnieniaDodatkowe);
    }
    /**
     * Get dataWystawieniaDokumentuRealizacji value
     * @return string
     */
    public function getDataWystawieniaDokumentuRealizacji()
    {
        return $this->dataWystawieniaDokumentuRealizacji;
    }
    /**
     * Set dataWystawieniaDokumentuRealizacji value
     * @param string $dataWystawieniaDokumentuRealizacji
     * @return DaneDokumentuRealizacjiReceptyMT
     */
    public function setDataWystawieniaDokumentuRealizacji($dataWystawieniaDokumentuRealizacji = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaDokumentuRealizacji) && !is_string($dataWystawieniaDokumentuRealizacji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaDokumentuRealizacji, true), gettype($dataWystawieniaDokumentuRealizacji)), __LINE__);
        }
        $this->dataWystawieniaDokumentuRealizacji = $dataWystawieniaDokumentuRealizacji;
        return $this;
    }
    /**
     * Get identyfikatorOpakowaniaLeku value
     * @return string|null
     */
    public function getIdentyfikatorOpakowaniaLeku()
    {
        return $this->identyfikatorOpakowaniaLeku;
    }
    /**
     * Set identyfikatorOpakowaniaLeku value
     * @param string $identyfikatorOpakowaniaLeku
     * @return DaneDokumentuRealizacjiReceptyMT
     */
    public function setIdentyfikatorOpakowaniaLeku($identyfikatorOpakowaniaLeku = null)
    {
        // validation for constraint: string
        if (!is_null($identyfikatorOpakowaniaLeku) && !is_string($identyfikatorOpakowaniaLeku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identyfikatorOpakowaniaLeku, true), gettype($identyfikatorOpakowaniaLeku)), __LINE__);
        }
        $this->identyfikatorOpakowaniaLeku = $identyfikatorOpakowaniaLeku;
        return $this;
    }
    /**
     * Get iloscLeku value
     * @return float|null
     */
    public function getIloscLeku()
    {
        return $this->iloscLeku;
    }
    /**
     * Set iloscLeku value
     * @param float $iloscLeku
     * @return DaneDokumentuRealizacjiReceptyMT
     */
    public function setIloscLeku($iloscLeku = null)
    {
        // validation for constraint: float
        if (!is_null($iloscLeku) && !(is_float($iloscLeku) || is_numeric($iloscLeku))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iloscLeku, true), gettype($iloscLeku)), __LINE__);
        }
        $this->iloscLeku = $iloscLeku;
        return $this;
    }
    /**
     * Get nazwaWydanegoLeku value
     * @return string|null
     */
    public function getNazwaWydanegoLeku()
    {
        return $this->nazwaWydanegoLeku;
    }
    /**
     * Set nazwaWydanegoLeku value
     * @param string $nazwaWydanegoLeku
     * @return DaneDokumentuRealizacjiReceptyMT
     */
    public function setNazwaWydanegoLeku($nazwaWydanegoLeku = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaWydanegoLeku) && !is_string($nazwaWydanegoLeku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaWydanegoLeku, true), gettype($nazwaWydanegoLeku)), __LINE__);
        }
        $this->nazwaWydanegoLeku = $nazwaWydanegoLeku;
        return $this;
    }
    /**
     * Get wielkoscOpakowania value
     * @return string|null
     */
    public function getWielkoscOpakowania()
    {
        return $this->wielkoscOpakowania;
    }
    /**
     * Set wielkoscOpakowania value
     * @param string $wielkoscOpakowania
     * @return DaneDokumentuRealizacjiReceptyMT
     */
    public function setWielkoscOpakowania($wielkoscOpakowania = null)
    {
        // validation for constraint: string
        if (!is_null($wielkoscOpakowania) && !is_string($wielkoscOpakowania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wielkoscOpakowania, true), gettype($wielkoscOpakowania)), __LINE__);
        }
        $this->wielkoscOpakowania = $wielkoscOpakowania;
        return $this;
    }
    /**
     * Get poziomOdplatnosciRealizacjiRecepty value
     * @return string|null
     */
    public function getPoziomOdplatnosciRealizacjiRecepty()
    {
        return $this->poziomOdplatnosciRealizacjiRecepty;
    }
    /**
     * Set poziomOdplatnosciRealizacjiRecepty value
     * @param string $poziomOdplatnosciRealizacjiRecepty
     * @return DaneDokumentuRealizacjiReceptyMT
     */
    public function setPoziomOdplatnosciRealizacjiRecepty($poziomOdplatnosciRealizacjiRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($poziomOdplatnosciRealizacjiRecepty) && !is_string($poziomOdplatnosciRealizacjiRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poziomOdplatnosciRealizacjiRecepty, true), gettype($poziomOdplatnosciRealizacjiRecepty)), __LINE__);
        }
        $this->poziomOdplatnosciRealizacjiRecepty = $poziomOdplatnosciRealizacjiRecepty;
        return $this;
    }
    /**
     * Get uprawnieniaDodatkowe value
     * @return UprawnieniaDodatkoweMT[]|null
     */
    public function getUprawnieniaDodatkowe()
    {
        return $this->uprawnieniaDodatkowe;
    }
    /**
     * This method is responsible for validating the values passed to the setUprawnieniaDodatkowe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUprawnieniaDodatkowe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUprawnieniaDodatkoweForArrayConstraintsFromSetUprawnieniaDodatkowe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $daneDokumentuRealizacjiReceptyMTUprawnieniaDodatkoweItem) {
            // validation for constraint: itemType
            if (!$daneDokumentuRealizacjiReceptyMTUprawnieniaDodatkoweItem instanceof UprawnieniaDodatkoweMT) {
                $invalidValues[] = is_object($daneDokumentuRealizacjiReceptyMTUprawnieniaDodatkoweItem) ? get_class($daneDokumentuRealizacjiReceptyMTUprawnieniaDodatkoweItem) : sprintf('%s(%s)', gettype($daneDokumentuRealizacjiReceptyMTUprawnieniaDodatkoweItem), var_export($daneDokumentuRealizacjiReceptyMTUprawnieniaDodatkoweItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The uprawnieniaDodatkowe property can only contain items of type UprawnieniaDodatkoweMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set uprawnieniaDodatkowe value
     * @throws \InvalidArgumentException
     * @param UprawnieniaDodatkoweMT[] $uprawnieniaDodatkowe
     * @return DaneDokumentuRealizacjiReceptyMT
     */
    public function setUprawnieniaDodatkowe(array $uprawnieniaDodatkowe = array())
    {
        // validation for constraint: array
        if ('' !== ($uprawnieniaDodatkoweArrayErrorMessage = self::validateUprawnieniaDodatkoweForArrayConstraintsFromSetUprawnieniaDodatkowe($uprawnieniaDodatkowe))) {
            throw new \InvalidArgumentException($uprawnieniaDodatkoweArrayErrorMessage, __LINE__);
        }
        $this->uprawnieniaDodatkowe = $uprawnieniaDodatkowe;
        return $this;
    }
    /**
     * Add item to uprawnieniaDodatkowe value
     * @throws \InvalidArgumentException
     * @param UprawnieniaDodatkoweMT $item
     * @return DaneDokumentuRealizacjiReceptyMT
     */
    public function addToUprawnieniaDodatkowe(UprawnieniaDodatkoweMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof UprawnieniaDodatkoweMT) {
            throw new \InvalidArgumentException(sprintf('The uprawnieniaDodatkowe property can only contain items of type UprawnieniaDodatkoweMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->uprawnieniaDodatkowe[] = $item;
        return $this;
    }
}
