<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zapis ServiceType
 * @subpackage Services
 */
class Zapis extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20170510', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * zapisRealizacjiReceptyFarmaceutycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Realizacja recepty farmaceutycznej elektronicznej. Parametrem wejściowym jest para: dokument recepty (XML, HL7 CDA) i dokument realizacji recepty (XML, HL7 CDA). Operacja udostępniana realizatorom recept (systemy apteczne).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZapisRealizacjiReceptyFarmaceutycznejRequest $zapisRealizacjiReceptyFarmaceutycznej
     * @return ZapisRealizacjiReceptyFarmaceutycznejResponse|bool
     */
    public function zapisRealizacjiReceptyFarmaceutycznej(ZapisRealizacjiReceptyFarmaceutycznejRequest $zapisRealizacjiReceptyFarmaceutycznej)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisRealizacjiReceptyFarmaceutycznej($zapisRealizacjiReceptyFarmaceutycznej));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named zapisRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Realizacja recepty elektronicznej i papierowej. Parametrem wejściowym jest dokument realizacji recepty (XML, HL7 CDA). Operacja udostępniana realizatorom recept (systemy apteczne).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZapisRealizacjiReceptyRequest $zapisRealizacjiRecepty
     * @return ZapisRealizacjiReceptyResponse|bool
     */
    public function zapisRealizacjiRecepty(ZapisRealizacjiReceptyRequest $zapisRealizacjiRecepty)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisRealizacjiRecepty($zapisRealizacjiRecepty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named zapisPakietuRecept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Zapis listy recept elektronicznych w systemie. Parametry wejściowe to podpisane elektronicznie recepty w formacie HL7 CDA. Wynikiem jest identyfikator zadania uruchomionego w P1 (w przypadku gdy operacja nie mogła być zakończona
     * synchronicznie) albo kod pakietu recept, klucze recept i pakietu recept oraz wyniki weryfikacji każdej z przekazanych recept.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZapisPakietuReceptRequest $zapisPakietuRecept
     * @return ZapisPakietuReceptResponse|bool
     */
    public function zapisPakietuRecept(ZapisPakietuReceptRequest $zapisPakietuRecept)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisPakietuRecept($zapisPakietuRecept));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named zapisPakietuRealizacjiRecept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Zapis listy realizacji recept w systemie. Parametry wejściowe to podpisane elektronicznie realizacje recepty w formacie HL7 CDA. Na wyjściu otrzymujemy wyniki weryfikacji każdej z przekazanych realizacji recept.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZapisPakietuRealizacjiReceptRequest $zapisPakietuRealizacjiRecept
     * @return ZapisPakietuRealizacjiReceptResponse|bool
     */
    public function zapisPakietuRealizacjiRecept(ZapisPakietuRealizacjiReceptRequest $zapisPakietuRealizacjiRecept)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisPakietuRealizacjiRecept($zapisPakietuRealizacjiRecept));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * zapisDokumentuAnulowaniaReceptyFarmaceutycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Zapisanie dokumentu anulowania recepty farmaceutycznej. Parametry wejściowe to para dokumentów: dokument anulowania recepty oraz dokument korekty realizacji recepty. Wynikiem operacji są wyniki weryfikacji przesłanej pary
     * dokumentów.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZapisDokumentuAnulowaniaReceptyFarmaceutycznejRequest $zapisDokumentuAnulowaniaReceptyFarmaceutycznej
     * @return ZapisDokumentuAnulowaniaReceptyFarmaceutycznejResponse|bool
     */
    public function zapisDokumentuAnulowaniaReceptyFarmaceutycznej(ZapisDokumentuAnulowaniaReceptyFarmaceutycznejRequest $zapisDokumentuAnulowaniaReceptyFarmaceutycznej)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisDokumentuAnulowaniaReceptyFarmaceutycznej($zapisDokumentuAnulowaniaReceptyFarmaceutycznej));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named zapisDokumentuAnulowaniaRecepty
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Zapisanie dokumentu anulowania recepty. Parametry wejściowe to klucz recepty, której dotyczy dokument anulowania oraz dokument anulowania wskazanej recepty. Wynikiem operacji są wyniki weryfikacji przesłanego dokumentu
     * anulowania.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZapisDokumentuAnulowaniaReceptyRequest $zapisDokumentuAnulowaniaRecepty
     * @return ZapisDokumentuAnulowaniaReceptyResponse|bool
     */
    public function zapisDokumentuAnulowaniaRecepty(ZapisDokumentuAnulowaniaReceptyRequest $zapisDokumentuAnulowaniaRecepty)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisDokumentuAnulowaniaRecepty($zapisDokumentuAnulowaniaRecepty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * zapisKorektyDokumentuRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Zapisanie korekty dokumentu realizacji recepty. Parametry wejściowe to klucz korygowanej recepty elektronicznej i dokument korekty realizacji wskazanej recepty. W przypadku korekty realizacji recepty papierowej, nie przekazuje się
     * klucza recepty. Wynikiem operacji są wyniki weryfikacji przesłanego dokumentu korekty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZapisKorektyDokumentuRealizacjiReceptyRequest $zapisKorektyDokumentuRealizacjiRecepty
     * @return ZapisKorektyDokumentuRealizacjiReceptyResponse|bool
     */
    public function zapisKorektyDokumentuRealizacjiRecepty(ZapisKorektyDokumentuRealizacjiReceptyRequest $zapisKorektyDokumentuRealizacjiRecepty)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisKorektyDokumentuRealizacjiRecepty($zapisKorektyDokumentuRealizacjiRecepty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ZapisDokumentuAnulowaniaReceptyFarmaceutycznejResponse|ZapisDokumentuAnulowaniaReceptyResponse|ZapisKorektyDokumentuRealizacjiReceptyResponse|ZapisPakietuRealizacjiReceptResponse|ZapisPakietuReceptResponse|ZapisRealizacjiReceptyFarmaceutycznejResponse|ZapisRealizacjiReceptyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
