<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikZapisuPakietuReceptMT StructType
 * @subpackage Structs
 */
class WynikZapisuPakietuReceptMT extends AbstractStructBase
{
    /**
     * The kluczPakietuRecept
     * Meta information extracted from the WSDL
     * - documentation: Klucz pakietu recept nadany przez System P1. Klucz jest nadawany, tylko w przypadku w pozytywnej weryfikacji wszystkich recept w pakiecie (brak błędów).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kluczPakietuRecept;
    /**
     * The kodPakietuRecept
     * Meta information extracted from the WSDL
     * - documentation: Kod pakietu recept nadany przez System P1. Kod pakietu jest nadawany, tylko w przypadku w pozytywnej weryfikacji wszystkich recept w pakiecie (brak błędów). Kod zbudowany jest 4 cyfr i numeru PESEL usługobiorcy.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kodPakietuRecept;
    /**
     * The wynikWeryfikacji
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var WynikWeryfikacjiReceptMT
     */
    public $wynikWeryfikacji;
    /**
     * Constructor method for WynikZapisuPakietuReceptMT
     * @uses WynikZapisuPakietuReceptMT::setKluczPakietuRecept()
     * @uses WynikZapisuPakietuReceptMT::setKodPakietuRecept()
     * @uses WynikZapisuPakietuReceptMT::setWynikWeryfikacji()
     * @param string $kluczPakietuRecept
     * @param string $kodPakietuRecept
     * @param WynikWeryfikacjiReceptMT $wynikWeryfikacji
     */
    public function __construct($kluczPakietuRecept = null, $kodPakietuRecept = null, WynikWeryfikacjiReceptMT $wynikWeryfikacji = null)
    {
        $this
            ->setKluczPakietuRecept($kluczPakietuRecept)
            ->setKodPakietuRecept($kodPakietuRecept)
            ->setWynikWeryfikacji($wynikWeryfikacji);
    }
    /**
     * Get kluczPakietuRecept value
     * @return string|null
     */
    public function getKluczPakietuRecept()
    {
        return $this->kluczPakietuRecept;
    }
    /**
     * Set kluczPakietuRecept value
     * @param string $kluczPakietuRecept
     * @return WynikZapisuPakietuReceptMT
     */
    public function setKluczPakietuRecept($kluczPakietuRecept = null)
    {
        // validation for constraint: string
        if (!is_null($kluczPakietuRecept) && !is_string($kluczPakietuRecept)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczPakietuRecept, true), gettype($kluczPakietuRecept)), __LINE__);
        }
        $this->kluczPakietuRecept = $kluczPakietuRecept;
        return $this;
    }
    /**
     * Get kodPakietuRecept value
     * @return string|null
     */
    public function getKodPakietuRecept()
    {
        return $this->kodPakietuRecept;
    }
    /**
     * Set kodPakietuRecept value
     * @param string $kodPakietuRecept
     * @return WynikZapisuPakietuReceptMT
     */
    public function setKodPakietuRecept($kodPakietuRecept = null)
    {
        // validation for constraint: string
        if (!is_null($kodPakietuRecept) && !is_string($kodPakietuRecept)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodPakietuRecept, true), gettype($kodPakietuRecept)), __LINE__);
        }
        $this->kodPakietuRecept = $kodPakietuRecept;
        return $this;
    }
    /**
     * Get wynikWeryfikacji value
     * @return WynikWeryfikacjiReceptMT|null
     */
    public function getWynikWeryfikacji()
    {
        return $this->wynikWeryfikacji;
    }
    /**
     * Set wynikWeryfikacji value
     * @param WynikWeryfikacjiReceptMT $wynikWeryfikacji
     * @return WynikZapisuPakietuReceptMT
     */
    public function setWynikWeryfikacji(WynikWeryfikacjiReceptMT $wynikWeryfikacji = null)
    {
        $this->wynikWeryfikacji = $wynikWeryfikacji;
        return $this;
    }
}
