<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikWyszukiwaniaDokumentowAnulowaniaMT StructType
 * @subpackage Structs
 */
class WynikWyszukiwaniaDokumentowAnulowaniaMT extends AbstractStructBase
{
    /**
     * The identyfikatorDokumentuAnulowaniaRecepty
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator dokumentu anulowania recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorDokumentuAnulowaniaReceptyMT
     */
    public $identyfikatorDokumentuAnulowaniaRecepty;
    /**
     * The dataWystawienia
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu anulowania recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataWystawienia;
    /**
     * The kluczRecepty
     * Meta information extracted from the WSDL
     * - documentation: Klucz recepty powiązany z wyszukanym dokumentem anulowania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var KluczReceptyMT
     */
    public $kluczRecepty;
    /**
     * Constructor method for WynikWyszukiwaniaDokumentowAnulowaniaMT
     * @uses WynikWyszukiwaniaDokumentowAnulowaniaMT::setIdentyfikatorDokumentuAnulowaniaRecepty()
     * @uses WynikWyszukiwaniaDokumentowAnulowaniaMT::setDataWystawienia()
     * @uses WynikWyszukiwaniaDokumentowAnulowaniaMT::setKluczRecepty()
     * @param IdentyfikatorDokumentuAnulowaniaReceptyMT $identyfikatorDokumentuAnulowaniaRecepty
     * @param string $dataWystawienia
     * @param KluczReceptyMT $kluczRecepty
     */
    public function __construct(IdentyfikatorDokumentuAnulowaniaReceptyMT $identyfikatorDokumentuAnulowaniaRecepty = null, $dataWystawienia = null, KluczReceptyMT $kluczRecepty = null)
    {
        $this
            ->setIdentyfikatorDokumentuAnulowaniaRecepty($identyfikatorDokumentuAnulowaniaRecepty)
            ->setDataWystawienia($dataWystawienia)
            ->setKluczRecepty($kluczRecepty);
    }
    /**
     * Get identyfikatorDokumentuAnulowaniaRecepty value
     * @return IdentyfikatorDokumentuAnulowaniaReceptyMT
     */
    public function getIdentyfikatorDokumentuAnulowaniaRecepty()
    {
        return $this->identyfikatorDokumentuAnulowaniaRecepty;
    }
    /**
     * Set identyfikatorDokumentuAnulowaniaRecepty value
     * @param IdentyfikatorDokumentuAnulowaniaReceptyMT $identyfikatorDokumentuAnulowaniaRecepty
     * @return WynikWyszukiwaniaDokumentowAnulowaniaMT
     */
    public function setIdentyfikatorDokumentuAnulowaniaRecepty(IdentyfikatorDokumentuAnulowaniaReceptyMT $identyfikatorDokumentuAnulowaniaRecepty = null)
    {
        $this->identyfikatorDokumentuAnulowaniaRecepty = $identyfikatorDokumentuAnulowaniaRecepty;
        return $this;
    }
    /**
     * Get dataWystawienia value
     * @return string
     */
    public function getDataWystawienia()
    {
        return $this->dataWystawienia;
    }
    /**
     * Set dataWystawienia value
     * @param string $dataWystawienia
     * @return WynikWyszukiwaniaDokumentowAnulowaniaMT
     */
    public function setDataWystawienia($dataWystawienia = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawienia) && !is_string($dataWystawienia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawienia, true), gettype($dataWystawienia)), __LINE__);
        }
        $this->dataWystawienia = $dataWystawienia;
        return $this;
    }
    /**
     * Get kluczRecepty value
     * @return KluczReceptyMT
     */
    public function getKluczRecepty()
    {
        return $this->kluczRecepty;
    }
    /**
     * Set kluczRecepty value
     * @param KluczReceptyMT $kluczRecepty
     * @return WynikWyszukiwaniaDokumentowAnulowaniaMT
     */
    public function setKluczRecepty(KluczReceptyMT $kluczRecepty = null)
    {
        $this->kluczRecepty = $kluczRecepty;
        return $this;
    }
}
