<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeryfikowanaReceptaMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Weryfikowany dokument recepty.
 * @subpackage Structs
 */
class WeryfikowanaReceptaMT extends AbstractStructBase
{
    /**
     * The numerReceptyWPakiecie
     * Meta information extracted from the WSDL
     * - documentation: Numer nadany dokumentowi recepty przez system wywołujący operację. Służy do korelacji wyników weryfikacji z przekazywanym dokumentem do zapisu lub weryfikacji.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numerReceptyWPakiecie;
    /**
     * The wynikWeryfikacjiZbioruRegul
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var WynikWeryfikacjiZbioruRegulMT
     */
    public $wynikWeryfikacjiZbioruRegul;
    /**
     * The kluczRecepty
     * Meta information extracted from the WSDL
     * - documentation: Klucz dokumentu recept nadany przez System P1. Klucz jest nadawany, tylko w przypadku w pełni pozytywnej weryfikacji - tzn. recepta nie zawiera błędu i w przypadku operacji zapisu zostałaby przyjęta do Systemu P1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kluczRecepty;
    /**
     * Constructor method for WeryfikowanaReceptaMT
     * @uses WeryfikowanaReceptaMT::setNumerReceptyWPakiecie()
     * @uses WeryfikowanaReceptaMT::setWynikWeryfikacjiZbioruRegul()
     * @uses WeryfikowanaReceptaMT::setKluczRecepty()
     * @param int $numerReceptyWPakiecie
     * @param WynikWeryfikacjiZbioruRegulMT $wynikWeryfikacjiZbioruRegul
     * @param string $kluczRecepty
     */
    public function __construct($numerReceptyWPakiecie = null, WynikWeryfikacjiZbioruRegulMT $wynikWeryfikacjiZbioruRegul = null, $kluczRecepty = null)
    {
        $this
            ->setNumerReceptyWPakiecie($numerReceptyWPakiecie)
            ->setWynikWeryfikacjiZbioruRegul($wynikWeryfikacjiZbioruRegul)
            ->setKluczRecepty($kluczRecepty);
    }
    /**
     * Get numerReceptyWPakiecie value
     * @return int
     */
    public function getNumerReceptyWPakiecie()
    {
        return $this->numerReceptyWPakiecie;
    }
    /**
     * Set numerReceptyWPakiecie value
     * @param int $numerReceptyWPakiecie
     * @return WeryfikowanaReceptaMT
     */
    public function setNumerReceptyWPakiecie($numerReceptyWPakiecie = null)
    {
        // validation for constraint: int
        if (!is_null($numerReceptyWPakiecie) && !(is_int($numerReceptyWPakiecie) || ctype_digit($numerReceptyWPakiecie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numerReceptyWPakiecie, true), gettype($numerReceptyWPakiecie)), __LINE__);
        }
        $this->numerReceptyWPakiecie = $numerReceptyWPakiecie;
        return $this;
    }
    /**
     * Get wynikWeryfikacjiZbioruRegul value
     * @return WynikWeryfikacjiZbioruRegulMT
     */
    public function getWynikWeryfikacjiZbioruRegul()
    {
        return $this->wynikWeryfikacjiZbioruRegul;
    }
    /**
     * Set wynikWeryfikacjiZbioruRegul value
     * @param WynikWeryfikacjiZbioruRegulMT $wynikWeryfikacjiZbioruRegul
     * @return WeryfikowanaReceptaMT
     */
    public function setWynikWeryfikacjiZbioruRegul(WynikWeryfikacjiZbioruRegulMT $wynikWeryfikacjiZbioruRegul = null)
    {
        $this->wynikWeryfikacjiZbioruRegul = $wynikWeryfikacjiZbioruRegul;
        return $this;
    }
    /**
     * Get kluczRecepty value
     * @return string|null
     */
    public function getKluczRecepty()
    {
        return $this->kluczRecepty;
    }
    /**
     * Set kluczRecepty value
     * @param string $kluczRecepty
     * @return WeryfikowanaReceptaMT
     */
    public function setKluczRecepty($kluczRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($kluczRecepty) && !is_string($kluczRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczRecepty, true), gettype($kluczRecepty)), __LINE__);
        }
        $this->kluczRecepty = $kluczRecepty;
        return $this;
    }
}
