<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimestampType StructType
 * Meta information extracted from the WSDL
 * - documentation: This complex type ties together the timestamp related elements into a composite type.
 * @subpackage Structs
 */
class TimestampType extends AbstractStructBase
{
    /**
     * The Created
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: wsu:Created
     * @var AttributedDateTime
     */
    public $Created;
    /**
     * The Expires
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: wsu:Expires
     * @var AttributedDateTime
     */
    public $Expires;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * Constructor method for TimestampType
     * @uses TimestampType::setCreated()
     * @uses TimestampType::setExpires()
     * @uses TimestampType::setAny()
     * @uses TimestampType::setId()
     * @param AttributedDateTime $created
     * @param AttributedDateTime $expires
     * @param \DOMDocument $any
     * @param string $id
     */
    public function __construct(AttributedDateTime $created = null, AttributedDateTime $expires = null, \DOMDocument $any = null, $id = null)
    {
        $this
            ->setCreated($created)
            ->setExpires($expires)
            ->setAny($any)
            ->setId($id);
    }
    /**
     * Get Created value
     * @return AttributedDateTime|null
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param AttributedDateTime $created
     * @return TimestampType
     */
    public function setCreated(AttributedDateTime $created = null)
    {
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Expires value
     * @return AttributedDateTime|null
     */
    public function getExpires()
    {
        return $this->Expires;
    }
    /**
     * Set Expires value
     * @param AttributedDateTime $expires
     * @return TimestampType
     */
    public function setExpires(AttributedDateTime $expires = null)
    {
        $this->Expires = $expires;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return TimestampType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return TimestampType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
